/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.SymbolStatsEstimate;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DecimalType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.SmallintType;
import com.facebook.presto.spi.type.TinyintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TypeProvider;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;

public class StatsNormalizer {
    public PlanNodeStatsEstimate normalize(PlanNodeStatsEstimate stats, TypeProvider types) {
        return this.normalize(stats, Optional.empty(), types);
    }

    public PlanNodeStatsEstimate normalize(PlanNodeStatsEstimate stats, Collection<Symbol> outputSymbols, TypeProvider types) {
        return this.normalize(stats, Optional.of(outputSymbols), types);
    }

    private PlanNodeStatsEstimate normalize(PlanNodeStatsEstimate stats, Optional<Collection<Symbol>> outputSymbols, TypeProvider types) {
        PlanNodeStatsEstimate.Builder normalized = PlanNodeStatsEstimate.buildFrom(stats);
        Predicate<Symbol> symbolFilter = outputSymbols.map(ImmutableSet::copyOf).map(set -> arg_0 -> ((ImmutableSet)set).contains(arg_0)).orElse(symbol -> true);
        for (Symbol symbol2 : stats.getSymbolsWithKnownStatistics()) {
            if (!symbolFilter.test(symbol2)) {
                normalized.removeSymbolStatistics(symbol2);
                continue;
            }
            SymbolStatsEstimate symbolStats = stats.getSymbolStatistics(symbol2);
            SymbolStatsEstimate normalizedSymbolStats = this.normalizeSymbolStats(symbol2, symbolStats, stats, types);
            if (SymbolStatsEstimate.UNKNOWN_STATS.equals(normalizedSymbolStats)) {
                normalized.removeSymbolStatistics(symbol2);
                continue;
            }
            if (Objects.equals(normalizedSymbolStats, symbolStats)) continue;
            normalized.addSymbolStatistics(symbol2, normalizedSymbolStats);
        }
        return normalized.build();
    }

    private SymbolStatsEstimate normalizeSymbolStats(Symbol symbol, SymbolStatsEstimate symbolStats, PlanNodeStatsEstimate stats, TypeProvider types) {
        if (SymbolStatsEstimate.UNKNOWN_STATS.equals(symbolStats)) {
            return SymbolStatsEstimate.UNKNOWN_STATS;
        }
        double outputRowCount = stats.getOutputRowCount();
        double distinctValuesCount = symbolStats.getDistinctValuesCount();
        double nullsFraction = symbolStats.getNullsFraction();
        if (!Double.isNaN(distinctValuesCount)) {
            double nonNullValues;
            Type type = Objects.requireNonNull(types.get(symbol), () -> "No stats for symbol " + symbol);
            double maxDistinctValuesByLowHigh = this.maxDistinctValuesByLowHigh(symbolStats, type);
            if (distinctValuesCount > maxDistinctValuesByLowHigh) {
                distinctValuesCount = maxDistinctValuesByLowHigh;
            }
            if (distinctValuesCount > outputRowCount) {
                distinctValuesCount = outputRowCount;
            }
            if (distinctValuesCount > (nonNullValues = outputRowCount * (1.0 - nullsFraction))) {
                double difference = distinctValuesCount - nonNullValues;
                distinctValuesCount -= difference / 2.0;
                nullsFraction = 1.0 - (nonNullValues += difference / 2.0) / outputRowCount;
            }
        }
        if (distinctValuesCount == 0.0) {
            return SymbolStatsEstimate.ZERO_STATS;
        }
        return SymbolStatsEstimate.buildFrom(symbolStats).setDistinctValuesCount(distinctValuesCount).setNullsFraction(nullsFraction).build();
    }

    private double maxDistinctValuesByLowHigh(SymbolStatsEstimate symbolStats, Type type) {
        if (symbolStats.statisticRange().length() == 0.0) {
            return 1.0;
        }
        if (!StatsNormalizer.isDiscrete(type)) {
            return Double.NaN;
        }
        double length = symbolStats.getHighValue() - symbolStats.getLowValue();
        if (Double.isNaN(length)) {
            return Double.NaN;
        }
        if (type instanceof DecimalType) {
            length *= Math.pow(10.0, ((DecimalType)type).getScale());
        }
        return Math.floor(length + 1.0);
    }

    private static boolean isDiscrete(Type type) {
        return type.equals(IntegerType.INTEGER) || type.equals(BigintType.BIGINT) || type.equals(SmallintType.SMALLINT) || type.equals(TinyintType.TINYINT) || type.equals(BooleanType.BOOLEAN) || type.equals(DateType.DATE) || type instanceof DecimalType;
    }
}

