/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.cost;

import com.facebook.presto.Session;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.SimpleStatsRule;
import com.facebook.presto.cost.StatsNormalizer;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.cost.StatsUtil;
import com.facebook.presto.cost.SymbolStatsEstimate;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.statistics.ColumnStatistics;
import com.facebook.presto.spi.statistics.TableStatistics;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.Lookup;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;

public class TableScanStatsRule
extends SimpleStatsRule<TableScanNode> {
    private static final Pattern<TableScanNode> PATTERN = Patterns.tableScan();
    private final Metadata metadata;

    public TableScanStatsRule(Metadata metadata, StatsNormalizer normalizer) {
        super(normalizer);
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
    }

    @Override
    public Pattern<TableScanNode> getPattern() {
        return PATTERN;
    }

    @Override
    protected Optional<PlanNodeStatsEstimate> doCalculate(TableScanNode node, StatsProvider sourceStats, Lookup lookup, Session session, TypeProvider types) {
        Constraint constraint = new Constraint(node.getCurrentConstraint());
        TableStatistics tableStatistics = this.metadata.getTableStatistics(session, node.getTable(), (Constraint<ColumnHandle>)constraint);
        HashMap<Symbol, SymbolStatsEstimate> outputSymbolStats = new HashMap<Symbol, SymbolStatsEstimate>();
        for (Map.Entry<Symbol, ColumnHandle> entry : node.getAssignments().entrySet()) {
            Symbol symbol = entry.getKey();
            Type symbolType = types.get(symbol);
            Optional columnStatistics = Optional.ofNullable(tableStatistics.getColumnStatistics().get(entry.getValue()));
            outputSymbolStats.put(symbol, columnStatistics.map(statistics -> this.toSymbolStatistics(tableStatistics, (ColumnStatistics)statistics, session, symbolType)).orElse(SymbolStatsEstimate.UNKNOWN_STATS));
        }
        return Optional.of(PlanNodeStatsEstimate.builder().setOutputRowCount(tableStatistics.getRowCount().getValue()).addSymbolStatistics(outputSymbolStats).build());
    }

    private SymbolStatsEstimate toSymbolStatistics(TableStatistics tableStatistics, ColumnStatistics columnStatistics, Session session, Type type) {
        double nullsFraction = columnStatistics.getNullsFraction().getValue();
        double nonNullRowsCount = tableStatistics.getRowCount().getValue() * (1.0 - nullsFraction);
        return SymbolStatsEstimate.builder().setLowValue(this.asDouble(session, type, columnStatistics.getOnlyRangeColumnStatistics().getLowValue()).orElse(Double.NEGATIVE_INFINITY)).setHighValue(this.asDouble(session, type, columnStatistics.getOnlyRangeColumnStatistics().getHighValue()).orElse(Double.POSITIVE_INFINITY)).setNullsFraction(nullsFraction).setDistinctValuesCount(columnStatistics.getOnlyRangeColumnStatistics().getDistinctValuesCount().getValue()).setAverageRowSize(columnStatistics.getOnlyRangeColumnStatistics().getDataSize().getValue() / nonNullRowsCount).build();
    }

    private OptionalDouble asDouble(Session session, Type type, Optional<Object> optionalValue) {
        return optionalValue.map(value -> StatsUtil.toStatsRepresentation(this.metadata, session, type, value)).orElseGet(OptionalDouble::empty);
    }
}

