/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.spi.CatalogSchemaName;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.NodeUtils;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.CreateSchema;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public class CreateSchemaTask
implements DataDefinitionTask<CreateSchema> {
    @Override
    public String getName() {
        return "CREATE SCHEMA";
    }

    @Override
    public String explain(CreateSchema statement, List<Expression> parameters) {
        return "CREATE SCHEMA " + statement.getSchemaName();
    }

    @Override
    public ListenableFuture<?> execute(CreateSchema statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        Session session = stateMachine.getSession();
        CatalogSchemaName schema = MetadataUtil.createCatalogSchemaName(session, (Node)statement, Optional.of(statement.getSchemaName()));
        accessControl.checkCanCreateSchema(session.getRequiredTransactionId(), session.getIdentity(), schema);
        if (metadata.schemaExists(session, schema)) {
            if (!statement.isNotExists()) {
                throw new SemanticException(SemanticErrorCode.SCHEMA_ALREADY_EXISTS, (Node)statement, "Schema '%s' already exists", schema);
            }
            return Futures.immediateFuture(null);
        }
        ConnectorId connectorId = metadata.getCatalogHandle(session, schema.getCatalogName()).orElseThrow(() -> new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_FOUND, "Catalog does not exist: " + schema.getCatalogName()));
        Map<String, Object> properties = metadata.getSchemaPropertyManager().getProperties(connectorId, schema.getCatalogName(), NodeUtils.mapFromProperties(statement.getProperties()), session, metadata, parameters);
        metadata.createSchema(session, schema, properties);
        return Futures.immediateFuture(null);
    }
}

