/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.ViewDefinition;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.DropView;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Optional;

public class DropViewTask
implements DataDefinitionTask<DropView> {
    @Override
    public String getName() {
        return "DROP VIEW";
    }

    @Override
    public ListenableFuture<?> execute(DropView statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        QualifiedObjectName name;
        Session session = stateMachine.getSession();
        Optional<ViewDefinition> view = metadata.getView(session, name = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getName()));
        if (!view.isPresent()) {
            if (!statement.isExists()) {
                throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "View '%s' does not exist", name);
            }
            return Futures.immediateFuture(null);
        }
        accessControl.checkCanDropView(session.getRequiredTransactionId(), session.getIdentity(), name);
        metadata.dropView(session, name);
        return Futures.immediateFuture(null);
    }
}

