/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.spi.QueryId;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.primitives.Chars;
import com.google.common.util.concurrent.Uninterruptibles;
import java.util.Collection;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import javax.annotation.concurrent.GuardedBy;
import org.joda.time.format.DateTimeFormat;
import org.joda.time.format.DateTimeFormatter;

public class QueryIdGenerator {
    private static final char[] BASE_32 = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'm', 'n', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '2', '3', '4', '5', '6', '7', '8', '9'};
    private static final DateTimeFormatter TIMESTAMP_FORMAT;
    private static final long BASE_SYSTEM_TIME_MILLIS;
    private static final long BASE_NANO_TIME;
    private final String coordinatorId;
    @GuardedBy(value="this")
    private long lastTimeInDays;
    @GuardedBy(value="this")
    private long lastTimeInSeconds;
    @GuardedBy(value="this")
    private String lastTimestamp;
    @GuardedBy(value="this")
    private int counter;

    public QueryIdGenerator() {
        StringBuilder coordinatorId = new StringBuilder(5);
        for (int i = 0; i < 5; ++i) {
            coordinatorId.append(BASE_32[ThreadLocalRandom.current().nextInt(32)]);
        }
        this.coordinatorId = coordinatorId.toString();
    }

    public String getCoordinatorId() {
        return this.coordinatorId;
    }

    public synchronized QueryId createNextQueryId() {
        long now;
        if (this.counter > 99999) {
            while (TimeUnit.MILLISECONDS.toSeconds(this.nowInMillis()) == this.lastTimeInSeconds) {
                Uninterruptibles.sleepUninterruptibly((long)1L, (TimeUnit)TimeUnit.SECONDS);
            }
            this.counter = 0;
        }
        if (TimeUnit.MILLISECONDS.toSeconds(now = this.nowInMillis()) != this.lastTimeInSeconds) {
            this.lastTimeInSeconds = TimeUnit.MILLISECONDS.toSeconds(now);
            this.lastTimestamp = TIMESTAMP_FORMAT.print(now);
            if (TimeUnit.MILLISECONDS.toDays(now) != this.lastTimeInDays) {
                this.lastTimeInDays = TimeUnit.MILLISECONDS.toDays(now);
                this.counter = 0;
            }
        }
        return new QueryId(String.format("%s_%05d_%s", this.lastTimestamp, this.counter++, this.coordinatorId));
    }

    @VisibleForTesting
    protected long nowInMillis() {
        return BASE_SYSTEM_TIME_MILLIS + TimeUnit.NANOSECONDS.toMillis(System.nanoTime() - BASE_NANO_TIME);
    }

    static {
        Preconditions.checkState((BASE_32.length == 32 ? 1 : 0) != 0);
        Preconditions.checkState((ImmutableSet.copyOf((Collection)Chars.asList((char[])BASE_32)).size() == 32 ? 1 : 0) != 0);
        TIMESTAMP_FORMAT = DateTimeFormat.forPattern((String)"YYYYMMdd_HHmmss").withZoneUTC();
        BASE_SYSTEM_TIME_MILLIS = System.currentTimeMillis();
        BASE_NANO_TIME = System.nanoTime();
    }
}

