/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.execution.DataDefinitionTask;
import com.facebook.presto.execution.QueryStateMachine;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.MetadataUtil;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.RenameTable;
import com.facebook.presto.transaction.TransactionManager;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Optional;

public class RenameTableTask
implements DataDefinitionTask<RenameTable> {
    @Override
    public String getName() {
        return "RENAME TABLE";
    }

    @Override
    public ListenableFuture<?> execute(RenameTable statement, TransactionManager transactionManager, Metadata metadata, AccessControl accessControl, QueryStateMachine stateMachine, List<Expression> parameters) {
        QualifiedObjectName tableName;
        Session session = stateMachine.getSession();
        Optional<TableHandle> tableHandle = metadata.getTableHandle(session, tableName = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getSource()));
        if (!tableHandle.isPresent()) {
            throw new SemanticException(SemanticErrorCode.MISSING_TABLE, (Node)statement, "Table '%s' does not exist", tableName);
        }
        QualifiedObjectName target = MetadataUtil.createQualifiedObjectName(session, (Node)statement, statement.getTarget());
        if (!metadata.getCatalogHandle(session, target.getCatalogName()).isPresent()) {
            throw new SemanticException(SemanticErrorCode.MISSING_CATALOG, (Node)statement, "Target catalog '%s' does not exist", target.getCatalogName());
        }
        if (metadata.getTableHandle(session, target).isPresent()) {
            throw new SemanticException(SemanticErrorCode.TABLE_ALREADY_EXISTS, (Node)statement, "Target table '%s' already exists", target);
        }
        if (!tableName.getCatalogName().equals(target.getCatalogName())) {
            throw new SemanticException(SemanticErrorCode.NOT_SUPPORTED, (Node)statement, "Table rename across catalogs is not supported", new Object[0]);
        }
        accessControl.checkCanRenameTable(session.getRequiredTransactionId(), session.getIdentity(), tableName, target);
        metadata.renameTable(session, tableHandle.get(), target);
        return Futures.immediateFuture(null);
    }
}

