/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.ExceededCpuLimitException;
import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.event.query.QueryMonitor;
import com.facebook.presto.execution.FailedQueryExecution;
import com.facebook.presto.execution.LocationFactory;
import com.facebook.presto.execution.ParameterExtractor;
import com.facebook.presto.execution.QueryExecution;
import com.facebook.presto.execution.QueryIdGenerator;
import com.facebook.presto.execution.QueryInfo;
import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryManagerConfig;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.execution.SqlQueryManagerStats;
import com.facebook.presto.execution.StageId;
import com.facebook.presto.execution.StateMachine;
import com.facebook.presto.execution.resourceGroups.ResourceGroupManager;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.memory.ClusterMemoryManager;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.SessionPropertyManager;
import com.facebook.presto.server.SessionContext;
import com.facebook.presto.server.SessionSupplier;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.NodeState;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.QueryId;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.resourceGroups.QueryType;
import com.facebook.presto.spi.resourceGroups.ResourceGroupId;
import com.facebook.presto.spi.resourceGroups.SelectionContext;
import com.facebook.presto.spi.resourceGroups.SelectionCriteria;
import com.facebook.presto.sql.ParsingUtil;
import com.facebook.presto.sql.SqlEnvironmentConfig;
import com.facebook.presto.sql.SqlPath;
import com.facebook.presto.sql.analyzer.ConstantExpressionVerifier;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.parser.ParsingException;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.Plan;
import com.facebook.presto.sql.tree.Execute;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.transaction.TransactionManager;
import com.facebook.presto.util.StatementUtils;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Ordering;
import com.google.common.util.concurrent.AbstractFuture;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.ThreadPoolExecutorMBean;
import io.airlift.concurrent.Threads;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.net.URI;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.concurrent.ThreadSafe;
import javax.inject.Inject;
import org.joda.time.DateTime;
import org.joda.time.ReadableInstant;
import org.weakref.jmx.Flatten;
import org.weakref.jmx.Managed;
import org.weakref.jmx.Nested;

@ThreadSafe
public class SqlQueryManager
implements QueryManager {
    private static final Logger log = Logger.get(SqlQueryManager.class);
    private final SqlParser sqlParser;
    private final ExecutorService queryExecutor;
    private final ThreadPoolExecutorMBean queryExecutorMBean;
    private final ResourceGroupManager resourceGroupManager;
    private final ClusterMemoryManager memoryManager;
    private final Optional<String> path;
    private final boolean isIncludeCoordinator;
    private final int maxQueryHistory;
    private final Duration minQueryExpireAge;
    private final int maxQueryLength;
    private final int initializationRequiredWorkers;
    private final Duration initializationTimeout;
    private final long initialNanos;
    private final Duration maxQueryCpuTime;
    private final ConcurrentMap<QueryId, QueryExecution> queries = new ConcurrentHashMap<QueryId, QueryExecution>();
    private final Queue<QueryExecution> expirationQueue = new LinkedBlockingQueue<QueryExecution>();
    private final Duration clientTimeout;
    private final ScheduledExecutorService queryManagementExecutor;
    private final ThreadPoolExecutorMBean queryManagementExecutorMBean;
    private final QueryMonitor queryMonitor;
    private final LocationFactory locationFactory;
    private final Metadata metadata;
    private final TransactionManager transactionManager;
    private final QueryIdGenerator queryIdGenerator;
    private final SessionSupplier sessionSupplier;
    private final InternalNodeManager internalNodeManager;
    private final Map<Class<? extends Statement>, QueryExecution.QueryExecutionFactory<?>> executionFactories;
    private final SqlQueryManagerStats stats = new SqlQueryManagerStats();
    private final AtomicBoolean acceptQueries = new AtomicBoolean();

    @Inject
    public SqlQueryManager(SqlParser sqlParser, NodeSchedulerConfig nodeSchedulerConfig, QueryManagerConfig queryManagerConfig, SqlEnvironmentConfig sqlEnvironmentConfig, QueryMonitor queryMonitor, ResourceGroupManager resourceGroupManager, ClusterMemoryManager memoryManager, LocationFactory locationFactory, TransactionManager transactionManager, QueryIdGenerator queryIdGenerator, SessionSupplier sessionSupplier, InternalNodeManager internalNodeManager, Map<Class<? extends Statement>, QueryExecution.QueryExecutionFactory<?>> executionFactories, Metadata metadata) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.executionFactories = Objects.requireNonNull(executionFactories, "executionFactories is null");
        this.queryExecutor = Executors.newCachedThreadPool(Threads.threadsNamed((String)"query-scheduler-%s"));
        this.queryExecutorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)this.queryExecutor);
        Objects.requireNonNull(nodeSchedulerConfig, "nodeSchedulerConfig is null");
        Objects.requireNonNull(queryManagerConfig, "queryManagerConfig is null");
        this.resourceGroupManager = Objects.requireNonNull(resourceGroupManager, "resourceGroupManager is null");
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
        this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
        this.locationFactory = Objects.requireNonNull(locationFactory, "locationFactory is null");
        this.transactionManager = Objects.requireNonNull(transactionManager, "transactionManager is null");
        this.metadata = Objects.requireNonNull(metadata, "transactionManager is null");
        this.queryIdGenerator = Objects.requireNonNull(queryIdGenerator, "queryIdGenerator is null");
        this.sessionSupplier = Objects.requireNonNull(sessionSupplier, "sessionSupplier is null");
        this.internalNodeManager = Objects.requireNonNull(internalNodeManager, "internalNodeManager is null");
        this.path = sqlEnvironmentConfig.getPath();
        this.isIncludeCoordinator = nodeSchedulerConfig.isIncludeCoordinator();
        this.minQueryExpireAge = queryManagerConfig.getMinQueryExpireAge();
        this.maxQueryHistory = queryManagerConfig.getMaxQueryHistory();
        this.clientTimeout = queryManagerConfig.getClientTimeout();
        this.maxQueryLength = queryManagerConfig.getMaxQueryLength();
        this.maxQueryCpuTime = queryManagerConfig.getQueryMaxCpuTime();
        this.initializationRequiredWorkers = queryManagerConfig.getInitializationRequiredWorkers();
        this.initializationTimeout = queryManagerConfig.getInitializationTimeout();
        this.initialNanos = System.nanoTime();
        this.queryManagementExecutor = Executors.newScheduledThreadPool(queryManagerConfig.getQueryManagerExecutorPoolSize(), Threads.threadsNamed((String)"query-management-%s"));
        this.queryManagementExecutorMBean = new ThreadPoolExecutorMBean((ThreadPoolExecutor)((Object)this.queryManagementExecutor));
    }

    @PostConstruct
    public void start() {
        this.queryManagementExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                try {
                    SqlQueryManager.this.failAbandonedQueries();
                }
                catch (Throwable e) {
                    log.error(e, "Error cancelling abandoned queries");
                }
                try {
                    SqlQueryManager.this.enforceMemoryLimits();
                }
                catch (Throwable e) {
                    log.error(e, "Error enforcing memory limits");
                }
                try {
                    SqlQueryManager.this.enforceTimeLimits();
                }
                catch (Throwable e) {
                    log.error(e, "Error enforcing query timeout limits");
                }
                try {
                    SqlQueryManager.this.enforceCpuLimits();
                }
                catch (Throwable e) {
                    log.error(e, "Error enforcing query CPU time limits");
                }
                try {
                    SqlQueryManager.this.removeExpiredQueries();
                }
                catch (Throwable e) {
                    log.error(e, "Error removing expired queries");
                }
                try {
                    SqlQueryManager.this.pruneExpiredQueries();
                }
                catch (Throwable e) {
                    log.error(e, "Error pruning expired queries");
                }
            }
        }, 1L, 1L, TimeUnit.SECONDS);
    }

    @PreDestroy
    public void stop() {
        boolean queryCancelled = false;
        for (QueryExecution queryExecution : this.queries.values()) {
            if (queryExecution.getState().isDone()) continue;
            log.info("Server shutting down. Query %s has been cancelled", new Object[]{queryExecution.getQueryId()});
            queryExecution.fail(new PrestoException((ErrorCodeSupplier)StandardErrorCode.SERVER_SHUTTING_DOWN, "Server is shutting down. Query " + queryExecution.getQueryId() + " has been cancelled"));
            queryCancelled = true;
        }
        if (queryCancelled) {
            try {
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
        this.queryManagementExecutor.shutdownNow();
        this.queryExecutor.shutdownNow();
    }

    @Override
    public List<QueryInfo> getAllQueryInfo() {
        return (List)this.queries.values().stream().map(queryExecution -> {
            try {
                return queryExecution.getQueryInfo();
            }
            catch (RuntimeException ignored) {
                return null;
            }
        }).filter(Objects::nonNull).collect(ImmutableList.toImmutableList());
    }

    @Override
    public void addOutputInfoListener(QueryId queryId, Consumer<QueryExecution.QueryOutputInfo> listener) {
        Objects.requireNonNull(listener, "listener is null");
        this.getQuery(queryId).addOutputInfoListener(listener);
    }

    @Override
    public void addStateChangeListener(QueryId queryId, StateMachine.StateChangeListener<QueryState> listener) {
        Objects.requireNonNull(listener, "listener is null");
        this.getQuery(queryId).addStateChangeListener(listener);
    }

    @Override
    public ListenableFuture<QueryState> getStateChange(QueryId queryId, QueryState currentState) {
        return this.tryGetQuery(queryId).map(query -> query.getStateChange(currentState)).orElseGet(() -> Futures.immediateFailedFuture((Throwable)new NoSuchElementException()));
    }

    @Override
    public QueryInfo getQueryInfo(QueryId queryId) {
        return this.getQuery(queryId).getQueryInfo();
    }

    @Override
    public Optional<ResourceGroupId> getQueryResourceGroup(QueryId queryId) {
        return this.tryGetQuery(queryId).flatMap(QueryExecution::getResourceGroup);
    }

    @Override
    public Plan getQueryPlan(QueryId queryId) {
        return this.getQuery(queryId).getQueryPlan();
    }

    @Override
    public Optional<QueryState> getQueryState(QueryId queryId) {
        return this.tryGetQuery(queryId).map(QueryExecution::getState);
    }

    @Override
    public void recordHeartbeat(QueryId queryId) {
        this.tryGetQuery(queryId).ifPresent(QueryExecution::recordHeartbeat);
    }

    @Override
    public QueryId createQueryId() {
        return this.queryIdGenerator.createNextQueryId();
    }

    @Override
    public ListenableFuture<?> createQuery(QueryId queryId, SessionContext sessionContext, String query) {
        QueryCreationFuture queryCreationFuture = new QueryCreationFuture();
        this.queryExecutor.submit(() -> {
            try {
                this.createQueryInternal(queryId, sessionContext, query);
                queryCreationFuture.set(null);
            }
            catch (Throwable e) {
                queryCreationFuture.setException(e);
            }
        });
        return queryCreationFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createQueryInternal(QueryId queryId, SessionContext sessionContext, String query) {
        Object queryExecution;
        Statement statement;
        SelectionContext selectionContext;
        Objects.requireNonNull(queryId, "queryId is null");
        Objects.requireNonNull(sessionContext, "sessionFactory is null");
        Objects.requireNonNull(query, "query is null");
        Preconditions.checkArgument((!query.isEmpty() ? 1 : 0) != 0, (Object)"query must not be empty string");
        Preconditions.checkArgument((!this.queries.containsKey(queryId) ? 1 : 0) != 0, (String)"query %s already exists", (Object)queryId);
        Session session = null;
        try {
            Statement innerStatement;
            Optional<QueryType> innerQueryType;
            if (!this.acceptQueries.get()) {
                int activeWorkerCount = this.internalNodeManager.getNodes(NodeState.ACTIVE).size();
                if (!this.isIncludeCoordinator) {
                    --activeWorkerCount;
                }
                if (Duration.nanosSince((long)this.initialNanos).compareTo(this.initializationTimeout) < 0 && activeWorkerCount < this.initializationRequiredWorkers) {
                    throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.SERVER_STARTING_UP, String.format("Cluster is still initializing, there are insufficient active worker nodes (%s) to run query", activeWorkerCount));
                }
                this.acceptQueries.set(true);
            }
            if (query.length() > this.maxQueryLength) {
                int queryLength = query.length();
                query = query.substring(0, this.maxQueryLength);
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.QUERY_TEXT_TOO_LARGE, String.format("Query text length (%s) exceeds the maximum length (%s)", queryLength, this.maxQueryLength));
            }
            Optional<String> queryType = this.getQueryType(query);
            selectionContext = this.resourceGroupManager.selectGroup(new SelectionCriteria(sessionContext.getIdentity().getPrincipal().isPresent(), sessionContext.getIdentity().getUser(), Optional.ofNullable(sessionContext.getSource()), sessionContext.getClientTags(), sessionContext.getResourceEstimates(), queryType));
            session = this.sessionSupplier.createSession(queryId, sessionContext, queryType, selectionContext.getResourceGroupId());
            Statement wrappedStatement = this.sqlParser.createStatement(query, ParsingUtil.createParsingOptions(session));
            statement = SqlQueryManager.unwrapExecuteStatement(wrappedStatement, this.sqlParser, session);
            List parameters = wrappedStatement instanceof Execute ? ((Execute)wrappedStatement).getParameters() : Collections.emptyList();
            SqlQueryManager.validateParameters(statement, parameters);
            QueryExecution.QueryExecutionFactory<?> queryExecutionFactory = this.executionFactories.get(statement.getClass());
            if (queryExecutionFactory == null) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Unsupported statement type: " + statement.getClass().getSimpleName());
            }
            if (statement instanceof Explain && ((Explain)statement).isAnalyze() && (!(innerQueryType = StatementUtils.getQueryType((innerStatement = ((Explain)statement).getStatement()).getClass())).isPresent() || innerQueryType.get() == QueryType.DATA_DEFINITION)) {
                throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "EXPLAIN ANALYZE doesn't support statement type: " + innerStatement.getClass().getSimpleName());
            }
            queryExecution = queryExecutionFactory.createQueryExecution(queryId, query, session, statement, parameters);
        }
        catch (PrestoException | SemanticException | ParsingException e) {
            URI self = this.locationFactory.createQueryLocation(queryId);
            if (session == null) {
                session = Session.builder(new SessionPropertyManager()).setQueryId(queryId).setIdentity(sessionContext.getIdentity()).setPath(new SqlPath(Optional.empty())).build();
            }
            FailedQueryExecution execution = new FailedQueryExecution(queryId, query, Optional.empty(), session, self, this.transactionManager, this.queryExecutor, this.metadata, e);
            try {
                this.queries.putIfAbsent(queryId, execution);
                QueryInfo queryInfo = execution.getQueryInfo();
                this.queryMonitor.queryCreatedEvent(queryInfo);
                this.queryMonitor.queryCompletedEvent(queryInfo);
                this.stats.queryQueued();
                this.stats.queryStarted();
                this.stats.queryStopped();
                this.stats.queryFinished(queryInfo);
            }
            finally {
                this.expirationQueue.add(execution);
            }
            return;
        }
        QueryInfo queryInfo = queryExecution.getQueryInfo();
        this.queryMonitor.queryCreatedEvent(queryInfo);
        queryExecution.addFinalQueryInfoListener(finalQueryInfo -> {
            try {
                QueryInfo info = queryExecution.getQueryInfo();
                this.stats.queryFinished(info);
                this.queryMonitor.queryCompletedEvent(info);
            }
            finally {
                this.expirationQueue.add((QueryExecution)queryExecution);
            }
        });
        this.addStatsListeners((QueryExecution)queryExecution);
        if (this.queries.putIfAbsent(queryId, (QueryExecution)queryExecution) != null) {
            return;
        }
        this.resourceGroupManager.submit(statement, (QueryExecution)queryExecution, selectionContext, this.queryExecutor);
    }

    private Optional<String> getQueryType(String query) {
        Statement statement = this.sqlParser.createStatement(query, new ParsingOptions(ParsingOptions.DecimalLiteralTreatment.AS_DECIMAL));
        return StatementUtils.getQueryType(statement.getClass()).map(Enum::name);
    }

    public static Statement unwrapExecuteStatement(Statement statement, SqlParser sqlParser, Session session) {
        if (!(statement instanceof Execute)) {
            return statement;
        }
        String sql = session.getPreparedStatementFromExecute((Execute)statement);
        return sqlParser.createStatement(sql, ParsingUtil.createParsingOptions(session));
    }

    public static void validateParameters(Statement node, List<Expression> parameterValues) {
        int parameterCount = ParameterExtractor.getParameterCount(node);
        if (parameterValues.size() != parameterCount) {
            throw new SemanticException(SemanticErrorCode.INVALID_PARAMETER_USAGE, (Node)node, "Incorrect number of parameters: expected %s but found %s", parameterCount, parameterValues.size());
        }
        for (Expression expression : parameterValues) {
            ConstantExpressionVerifier.verifyExpressionIsConstant(Collections.emptySet(), expression);
        }
    }

    @Override
    public void failQuery(QueryId queryId, Throwable cause) {
        Objects.requireNonNull(cause, "cause is null");
        this.tryGetQuery(queryId).ifPresent(query -> query.fail(cause));
    }

    @Override
    public void cancelQuery(QueryId queryId) {
        log.debug("Cancel query %s", new Object[]{queryId});
        this.tryGetQuery(queryId).ifPresent(QueryExecution::cancelQuery);
    }

    @Override
    public void cancelStage(StageId stageId) {
        Objects.requireNonNull(stageId, "stageId is null");
        log.debug("Cancel stage %s", new Object[]{stageId});
        this.tryGetQuery(stageId.getQueryId()).ifPresent(query -> query.cancelStage(stageId));
    }

    @Override
    @Managed
    @Flatten
    public SqlQueryManagerStats getStats() {
        return this.stats;
    }

    @Managed(description="Query scheduler executor")
    @Nested
    public ThreadPoolExecutorMBean getExecutor() {
        return this.queryExecutorMBean;
    }

    @Managed(description="Query garbage collector executor")
    @Nested
    public ThreadPoolExecutorMBean getManagementExecutor() {
        return this.queryManagementExecutorMBean;
    }

    public void enforceMemoryLimits() {
        List runningQueries = (List)this.queries.values().stream().filter(query -> query.getState() == QueryState.RUNNING).collect(ImmutableList.toImmutableList());
        this.memoryManager.process(runningQueries, this::getAllQueryInfo);
    }

    public void enforceTimeLimits() {
        for (QueryExecution query : this.queries.values()) {
            if (query.getState().isDone()) continue;
            Duration queryMaxRunTime = SystemSessionProperties.getQueryMaxRunTime(query.getSession());
            Duration queryMaxExecutionTime = SystemSessionProperties.getQueryMaxExecutionTime(query.getSession());
            DateTime executionStartTime = query.getQueryInfo().getQueryStats().getExecutionStartTime();
            DateTime createTime = query.getQueryInfo().getQueryStats().getCreateTime();
            if (executionStartTime != null && executionStartTime.plus(queryMaxExecutionTime.toMillis()).isBeforeNow()) {
                query.fail(new PrestoException((ErrorCodeSupplier)StandardErrorCode.EXCEEDED_TIME_LIMIT, "Query exceeded the maximum execution time limit of " + queryMaxExecutionTime));
            }
            if (!createTime.plus(queryMaxRunTime.toMillis()).isBeforeNow()) continue;
            query.fail(new PrestoException((ErrorCodeSupplier)StandardErrorCode.EXCEEDED_TIME_LIMIT, "Query exceeded maximum time limit of " + queryMaxRunTime));
        }
    }

    public void enforceCpuLimits() {
        for (QueryExecution query : this.queries.values()) {
            Duration cpuTime = query.getTotalCpuTime();
            Duration sessionLimit = SystemSessionProperties.getQueryMaxCpuTime(query.getSession());
            Duration limit = (Duration)Ordering.natural().min((Object)this.maxQueryCpuTime, (Object)sessionLimit);
            if (cpuTime.compareTo(limit) <= 0) continue;
            query.fail((Throwable)((Object)new ExceededCpuLimitException(limit)));
        }
    }

    private void pruneExpiredQueries() {
        if (this.expirationQueue.size() <= this.maxQueryHistory) {
            return;
        }
        int count = 0;
        for (QueryExecution query : this.expirationQueue) {
            if (this.expirationQueue.size() - count <= this.maxQueryHistory) break;
            query.pruneInfo();
            ++count;
        }
    }

    private void removeExpiredQueries() {
        DateTime timeHorizon = DateTime.now().minus(this.minQueryExpireAge.toMillis());
        while (this.expirationQueue.size() > this.maxQueryHistory) {
            QueryInfo queryInfo = this.expirationQueue.peek().getQueryInfo();
            if (queryInfo.getQueryStats().getEndTime().isAfter((ReadableInstant)timeHorizon)) {
                return;
            }
            QueryId queryId = queryInfo.getQueryId();
            log.debug("Remove query %s", new Object[]{queryId});
            this.queries.remove(queryId);
            this.expirationQueue.remove();
        }
    }

    public void failAbandonedQueries() {
        for (QueryExecution queryExecution : this.queries.values()) {
            try {
                QueryInfo queryInfo = queryExecution.getQueryInfo();
                if (queryInfo.getState().isDone() || !this.isAbandoned(queryInfo)) continue;
                log.info("Failing abandoned query %s", new Object[]{queryExecution.getQueryId()});
                queryExecution.fail(new PrestoException((ErrorCodeSupplier)StandardErrorCode.ABANDONED_QUERY, String.format("Query %s has not been accessed since %s: currentTime %s", queryInfo.getQueryId(), queryInfo.getQueryStats().getLastHeartbeat(), DateTime.now())));
            }
            catch (RuntimeException e) {
                log.error((Throwable)e, "Exception failing abandoned query %s", new Object[]{queryExecution.getQueryId()});
            }
        }
    }

    private boolean isAbandoned(QueryInfo queryInfo) {
        DateTime oldestAllowedHeartbeat = DateTime.now().minus(this.clientTimeout.toMillis());
        DateTime lastHeartbeat = queryInfo.getQueryStats().getLastHeartbeat();
        return lastHeartbeat != null && lastHeartbeat.isBefore((ReadableInstant)oldestAllowedHeartbeat);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addStatsListeners(QueryExecution queryExecution) {
        Object lock = new Object();
        this.stats.queryQueued();
        AtomicBoolean started = new AtomicBoolean();
        queryExecution.addStateChangeListener(newValue -> {
            Object object = lock;
            synchronized (object) {
                if (newValue == QueryState.RUNNING && !started.getAndSet(true)) {
                    this.stats.queryStarted();
                }
            }
        });
        Object object = lock;
        synchronized (object) {
            if (queryExecution.getState() == QueryState.RUNNING && !started.getAndSet(true)) {
                this.stats.queryStarted();
            }
        }
        AtomicBoolean stopped = new AtomicBoolean();
        queryExecution.addStateChangeListener(newValue -> {
            Object object = lock;
            synchronized (object) {
                if (newValue.isDone() && !stopped.getAndSet(true) && started.get()) {
                    this.stats.queryStopped();
                }
            }
        });
        Object object2 = lock;
        synchronized (object2) {
            if (queryExecution.getState().isDone() && !stopped.getAndSet(true) && started.get()) {
                this.stats.queryStopped();
            }
        }
    }

    private QueryExecution getQuery(QueryId queryId) {
        return this.tryGetQuery(queryId).orElseThrow(NoSuchElementException::new);
    }

    private Optional<QueryExecution> tryGetQuery(QueryId queryId) {
        Objects.requireNonNull(queryId, "queryId is null");
        return Optional.ofNullable(this.queries.get(queryId));
    }

    private static class QueryCreationFuture
    extends AbstractFuture<QueryInfo> {
        private QueryCreationFuture() {
        }

        protected boolean set(QueryInfo value) {
            return super.set((Object)value);
        }

        protected boolean setException(Throwable throwable) {
            return super.setException(throwable);
        }

        public boolean cancel(boolean mayInterruptIfRunning) {
            return false;
        }
    }
}

