/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution;

import com.facebook.presto.Session;
import com.facebook.presto.TaskSource;
import com.facebook.presto.event.query.QueryMonitor;
import com.facebook.presto.execution.SqlTaskExecution;
import com.facebook.presto.execution.TaskManagerConfig;
import com.facebook.presto.execution.TaskStateMachine;
import com.facebook.presto.execution.buffer.OutputBuffer;
import com.facebook.presto.execution.executor.TaskExecutor;
import com.facebook.presto.memory.QueryContext;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.planner.LocalExecutionPlanner;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.TypeProvider;
import com.google.common.base.Throwables;
import io.airlift.concurrent.SetThreadName;
import java.util.List;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.Executor;

public class SqlTaskExecutionFactory {
    private static final String VERBOSE_STATS_PROPERTY = "verbose_stats";
    private final Executor taskNotificationExecutor;
    private final TaskExecutor taskExecutor;
    private final LocalExecutionPlanner planner;
    private final QueryMonitor queryMonitor;
    private final boolean verboseStats;
    private final boolean cpuTimerEnabled;

    public SqlTaskExecutionFactory(Executor taskNotificationExecutor, TaskExecutor taskExecutor, LocalExecutionPlanner planner, QueryMonitor queryMonitor, TaskManagerConfig config) {
        this.taskNotificationExecutor = Objects.requireNonNull(taskNotificationExecutor, "taskNotificationExecutor is null");
        this.taskExecutor = Objects.requireNonNull(taskExecutor, "taskExecutor is null");
        this.planner = Objects.requireNonNull(planner, "planner is null");
        this.queryMonitor = Objects.requireNonNull(queryMonitor, "queryMonitor is null");
        Objects.requireNonNull(config, "config is null");
        this.verboseStats = config.isVerboseStats();
        this.cpuTimerEnabled = config.isTaskCpuTimerEnabled();
    }

    public SqlTaskExecution create(Session session, QueryContext queryContext, TaskStateMachine taskStateMachine, OutputBuffer outputBuffer, PlanFragment fragment, List<TaskSource> sources, OptionalInt totalPartitions) {
        LocalExecutionPlanner.LocalExecutionPlan localExecutionPlan;
        boolean verboseStats = this.getVerboseStats(session);
        TaskContext taskContext = queryContext.addTaskContext(taskStateMachine, session, verboseStats, this.cpuTimerEnabled, totalPartitions);
        try (SetThreadName ignored = new SetThreadName("Task-%s", new Object[]{taskStateMachine.getTaskId()});){
            try {
                localExecutionPlan = this.planner.plan(taskContext, fragment.getRoot(), TypeProvider.copyOf(fragment.getSymbols()), fragment.getPartitioningScheme(), fragment.getStageExecutionStrategy(), fragment.getPartitionedSources(), outputBuffer);
            }
            catch (Throwable e) {
                taskStateMachine.failed(e);
                Throwables.throwIfUnchecked((Throwable)e);
                throw new RuntimeException(e);
            }
        }
        return SqlTaskExecution.createSqlTaskExecution(taskStateMachine, taskContext, outputBuffer, sources, localExecutionPlan, this.taskExecutor, this.taskNotificationExecutor, this.queryMonitor);
    }

    private boolean getVerboseStats(Session session) {
        String verboseStats = session.getSystemProperties().get(VERBOSE_STATS_PROPERTY);
        if (verboseStats == null) {
            return this.verboseStats;
        }
        try {
            return Boolean.valueOf(verboseStats.toUpperCase());
        }
        catch (IllegalArgumentException e) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "Invalid property 'verbose_stats=" + verboseStats + "'");
        }
    }
}

