/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.execution.buffer;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;

public enum PageCompression {
    UNCOMPRESSED(0),
    COMPRESSED(1);

    private final byte marker;

    private PageCompression(byte marker) {
        this.marker = marker;
    }

    public byte getMarker() {
        return this.marker;
    }

    public static PageCompression lookupCodecFromMarker(byte marker) {
        if (marker != UNCOMPRESSED.getMarker() && marker != COMPRESSED.getMarker()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.CORRUPT_PAGE, "Page marker did not contain expected value");
        }
        return UNCOMPRESSED.getMarker() == marker ? UNCOMPRESSED : COMPRESSED;
    }
}

