/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.memory;

import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.DefunctConfig;
import io.airlift.units.DataSize;
import io.airlift.units.Duration;
import io.airlift.units.MinDuration;
import java.util.concurrent.TimeUnit;
import javax.validation.constraints.NotNull;

@DefunctConfig(value={"experimental.cluster-memory-manager-enabled", "query.low-memory-killer.enabled"})
public class MemoryManagerConfig {
    private DataSize maxQueryMemory = new DataSize(20.0, DataSize.Unit.GIGABYTE);
    private DataSize maxQueryTotalMemory;
    private String lowMemoryKillerPolicy = "none";
    private Duration killOnOutOfMemoryDelay = new Duration(5.0, TimeUnit.MINUTES);

    public String getLowMemoryKillerPolicy() {
        return this.lowMemoryKillerPolicy;
    }

    @Config(value="query.low-memory-killer.policy")
    public MemoryManagerConfig setLowMemoryKillerPolicy(String lowMemoryKillerPolicy) {
        this.lowMemoryKillerPolicy = lowMemoryKillerPolicy;
        return this;
    }

    @NotNull
    @MinDuration(value="5s")
    public Duration getKillOnOutOfMemoryDelay() {
        return this.killOnOutOfMemoryDelay;
    }

    @Config(value="query.low-memory-killer.delay")
    @ConfigDescription(value="Delay between cluster running low on memory and invoking killer")
    public MemoryManagerConfig setKillOnOutOfMemoryDelay(Duration killOnOutOfMemoryDelay) {
        this.killOnOutOfMemoryDelay = killOnOutOfMemoryDelay;
        return this;
    }

    @NotNull
    public DataSize getMaxQueryMemory() {
        return this.maxQueryMemory;
    }

    @Config(value="query.max-memory")
    public MemoryManagerConfig setMaxQueryMemory(DataSize maxQueryMemory) {
        this.maxQueryMemory = maxQueryMemory;
        return this;
    }

    @NotNull
    public DataSize getMaxQueryTotalMemory() {
        if (this.maxQueryTotalMemory == null) {
            return DataSize.succinctBytes((long)(this.maxQueryMemory.toBytes() * 2L));
        }
        return this.maxQueryTotalMemory;
    }

    @Config(value="query.max-total-memory")
    public MemoryManagerConfig setMaxQueryTotalMemory(DataSize maxQueryTotalMemory) {
        this.maxQueryTotalMemory = maxQueryTotalMemory;
        return this;
    }

    public static class LowMemoryKillerPolicy {
        public static final String NONE = "none";
        public static final String TOTAL_RESERVATION = "total-reservation";
        public static final String TOTAL_RESERVATION_ON_BLOCKED_NODES = "total-reservation-on-blocked-nodes";
    }
}

