/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.metadata.AllNodes;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.PrestoNode;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeState;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Multimaps;
import com.google.common.collect.SetMultimap;
import java.net.URI;
import java.util.Collection;
import java.util.Set;
import javax.inject.Inject;

public class InMemoryNodeManager
implements InternalNodeManager {
    private final Node localNode;
    private final SetMultimap<ConnectorId, Node> remoteNodes = Multimaps.synchronizedSetMultimap((SetMultimap)HashMultimap.create());

    @Inject
    public InMemoryNodeManager() {
        this(URI.create("local://127.0.0.1"));
    }

    public InMemoryNodeManager(URI localUri) {
        this.localNode = new PrestoNode("local", localUri, NodeVersion.UNKNOWN, false);
    }

    public void addCurrentNodeConnector(ConnectorId connectorId) {
        this.addNode(connectorId, this.localNode);
    }

    public void addNode(ConnectorId connectorId, Node ... nodes) {
        this.addNode(connectorId, (Iterable<Node>)ImmutableList.copyOf((Object[])nodes));
    }

    public void addNode(ConnectorId connectorId, Iterable<Node> nodes) {
        this.remoteNodes.putAll((Object)connectorId, nodes);
    }

    @Override
    public Set<Node> getNodes(NodeState state) {
        switch (state) {
            case ACTIVE: {
                return this.getAllNodes().getActiveNodes();
            }
            case INACTIVE: {
                return this.getAllNodes().getInactiveNodes();
            }
            case SHUTTING_DOWN: {
                return this.getAllNodes().getShuttingDownNodes();
            }
        }
        throw new IllegalArgumentException("Unknown node state " + state);
    }

    @Override
    public Set<Node> getActiveConnectorNodes(ConnectorId connectorId) {
        return ImmutableSet.copyOf((Collection)this.remoteNodes.get((Object)connectorId));
    }

    @Override
    public AllNodes getAllNodes() {
        return new AllNodes((Set<Node>)ImmutableSet.builder().add((Object)this.localNode).addAll((Iterable)this.remoteNodes.values()).build(), (Set<Node>)ImmutableSet.of(), (Set<Node>)ImmutableSet.of());
    }

    @Override
    public Node getCurrentNode() {
        return this.localNode;
    }

    @Override
    public Set<Node> getCoordinators() {
        return ImmutableSet.of((Object)this.localNode);
    }

    @Override
    public void refreshNodes() {
    }
}

