/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.client.NodeVersion;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Node;
import com.google.common.base.MoreObjects;
import com.google.common.base.Strings;
import java.net.URI;
import java.util.Objects;

public class PrestoNode
implements Node {
    private final String nodeIdentifier;
    private final URI httpUri;
    private final NodeVersion nodeVersion;
    private final boolean coordinator;

    public PrestoNode(String nodeIdentifier, URI httpUri, NodeVersion nodeVersion, boolean coordinator) {
        nodeIdentifier = Strings.emptyToNull((String)Strings.nullToEmpty((String)nodeIdentifier).trim());
        this.nodeIdentifier = Objects.requireNonNull(nodeIdentifier, "nodeIdentifier is null or empty");
        this.httpUri = Objects.requireNonNull(httpUri, "httpUri is null");
        this.nodeVersion = Objects.requireNonNull(nodeVersion, "nodeVersion is null");
        this.coordinator = coordinator;
    }

    public String getNodeIdentifier() {
        return this.nodeIdentifier;
    }

    public URI getHttpUri() {
        return this.httpUri;
    }

    public HostAddress getHostAndPort() {
        return HostAddress.fromUri((URI)this.httpUri);
    }

    public String getVersion() {
        return this.nodeVersion.getVersion();
    }

    public boolean isCoordinator() {
        return this.coordinator;
    }

    public NodeVersion getNodeVersion() {
        return this.nodeVersion;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrestoNode o = (PrestoNode)obj;
        return this.nodeIdentifier.equals(o.nodeIdentifier);
    }

    public int hashCode() {
        return this.nodeIdentifier.hashCode();
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("nodeIdentifier", (Object)this.nodeIdentifier).add("httpUri", (Object)this.httpUri).add("nodeVersion", (Object)this.nodeVersion).toString();
    }
}

