/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionKind;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.PolymorphicScalarFunctionBuilder;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlFunction;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.type.TypeManager;
import com.google.common.base.Preconditions;
import java.util.Objects;

public abstract class SqlScalarFunction
implements SqlFunction {
    private final Signature signature;

    protected SqlScalarFunction(Signature signature) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        Preconditions.checkArgument((signature.getKind() == FunctionKind.SCALAR ? 1 : 0) != 0, (Object)"function kind must be SCALAR");
    }

    @Override
    public final Signature getSignature() {
        return this.signature;
    }

    public abstract ScalarFunctionImplementation specialize(BoundVariables var1, int var2, TypeManager var3, FunctionRegistry var4);

    public static PolymorphicScalarFunctionBuilder builder(Class<?> clazz) {
        return new PolymorphicScalarFunctionBuilder(clazz);
    }
}

