/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.metadata;

import com.facebook.presto.metadata.TableLayout;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.Collection;
import java.util.List;

public class TableLayoutResult {
    private final TableLayout layout;
    private final TupleDomain<ColumnHandle> unenforcedConstraint;

    public TableLayoutResult(TableLayout layout, TupleDomain<ColumnHandle> unenforcedConstraint) {
        this.layout = layout;
        this.unenforcedConstraint = unenforcedConstraint;
    }

    public TableLayout getLayout() {
        return this.layout;
    }

    public TupleDomain<ColumnHandle> getUnenforcedConstraint() {
        return this.unenforcedConstraint;
    }

    public boolean hasAllOutputs(TableScanNode node) {
        if (!this.layout.getColumns().isPresent()) {
            return true;
        }
        ImmutableSet columns = ImmutableSet.copyOf((Collection)this.layout.getColumns().get());
        List nodeColumnHandles = (List)node.getOutputSymbols().stream().map(node.getAssignments()::get).collect(ImmutableList.toImmutableList());
        return columns.containsAll(nodeColumnHandles);
    }
}

