/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.operator.LookupSourceFactory;
import com.facebook.presto.operator.NestedLoopJoinPagesBridge;
import com.facebook.presto.operator.PipelineExecutionStrategy;
import com.facebook.presto.operator.ReferenceCount;
import com.facebook.presto.operator.SharedLookupSourceFactory;
import com.facebook.presto.operator.SharedNestedLoopJoinPagesBridge;
import com.facebook.presto.spi.type.Type;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Suppliers;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class JoinBridgeDataManager<T> {
    private final List<Type> buildOutputTypes;
    private final InternalJoinBridgeDataManager<T> internalJoinBridgeDataManager;

    public static JoinBridgeDataManager<LookupSourceFactory> lookup(PipelineExecutionStrategy probeExecutionStrategy, PipelineExecutionStrategy lookupSourceExecutionStrategy, Function<Lifespan, LookupSourceFactory> lookupSourceFactoryProvider, List<Type> buildOutputTypes) {
        return new JoinBridgeDataManager<LookupSourceFactory>(probeExecutionStrategy, lookupSourceExecutionStrategy, lookupSourceFactoryProvider, buildOutputTypes, SharedLookupSourceFactory::new, LookupSourceFactory::destroy);
    }

    public static JoinBridgeDataManager<NestedLoopJoinPagesBridge> nestedLoop(PipelineExecutionStrategy probeExecutionStrategy, PipelineExecutionStrategy buildExecutionStrategy, Function<Lifespan, NestedLoopJoinPagesBridge> nestedLoopJoinPagesSupplierProvider, List<Type> buildOutputTypes) {
        Preconditions.checkArgument((buildExecutionStrategy == PipelineExecutionStrategy.UNGROUPED_EXECUTION ? 1 : 0) != 0, (Object)"Grouped execution for nested loop build is not supported");
        return new JoinBridgeDataManager<NestedLoopJoinPagesBridge>(probeExecutionStrategy, buildExecutionStrategy, nestedLoopJoinPagesSupplierProvider, buildOutputTypes, SharedNestedLoopJoinPagesBridge::new, NestedLoopJoinPagesBridge::destroy);
    }

    @VisibleForTesting
    public static JoinBridgeDataManager<LookupSourceFactory> lookupAllAtOnce(LookupSourceFactory factory) {
        return JoinBridgeDataManager.lookup(PipelineExecutionStrategy.UNGROUPED_EXECUTION, PipelineExecutionStrategy.UNGROUPED_EXECUTION, ignored -> factory, factory.getOutputTypes());
    }

    private JoinBridgeDataManager(PipelineExecutionStrategy probeExecutionStrategy, PipelineExecutionStrategy lookupSourceExecutionStrategy, Function<Lifespan, T> lookupSourceFactoryProvider, List<Type> buildOutputTypes, BiFunction<T, Runnable, T> sharedWrapper, Consumer<T> destroy) {
        Objects.requireNonNull(probeExecutionStrategy, "probeExecutionStrategy is null");
        Objects.requireNonNull(lookupSourceExecutionStrategy, "lookupSourceExecutionStrategy is null");
        Objects.requireNonNull(lookupSourceFactoryProvider, "joinBridgeProvider is null");
        this.internalJoinBridgeDataManager = JoinBridgeDataManager.internalJoinBridgeDataManager(probeExecutionStrategy, lookupSourceExecutionStrategy, lookupSourceFactoryProvider, sharedWrapper, destroy);
        this.buildOutputTypes = Objects.requireNonNull(buildOutputTypes, "buildOutputTypes is null");
    }

    public List<Type> getBuildOutputTypes() {
        return this.buildOutputTypes;
    }

    public T forLifespan(Lifespan lifespan) {
        return this.internalJoinBridgeDataManager.get(lifespan);
    }

    public void noMoreJoinBridge() {
        this.internalJoinBridgeDataManager.noMoreLookupSourceFactory();
    }

    private static <T> InternalJoinBridgeDataManager<T> internalJoinBridgeDataManager(PipelineExecutionStrategy probeExecutionStrategy, PipelineExecutionStrategy lookupSourceExecutionStrategy, Function<Lifespan, T> lookupSourceFactoryProvider, BiFunction<T, Runnable, T> sharedWrapper, Consumer<T> destroy) {
        switch (probeExecutionStrategy) {
            case UNGROUPED_EXECUTION: {
                switch (lookupSourceExecutionStrategy) {
                    case UNGROUPED_EXECUTION: {
                        return new TaskWideInternalJoinBridgeDataManager<T>(lookupSourceFactoryProvider);
                    }
                    case GROUPED_EXECUTION: {
                        throw new UnsupportedOperationException("Invalid combination. Lookup source should not be grouped if probe is not going to take advantage of it.");
                    }
                }
                throw new IllegalArgumentException("Unknown lookupSourceExecutionStrategy: " + (Object)((Object)lookupSourceExecutionStrategy));
            }
            case GROUPED_EXECUTION: {
                switch (lookupSourceExecutionStrategy) {
                    case UNGROUPED_EXECUTION: {
                        return new SharedInternalJoinBridgeDataManager<T>(lookupSourceFactoryProvider, sharedWrapper, destroy);
                    }
                    case GROUPED_EXECUTION: {
                        return new OneToOneInternalJoinBridgeDataManager<T>(lookupSourceFactoryProvider);
                    }
                }
                throw new IllegalArgumentException("Unknown lookupSourceExecutionStrategy: " + (Object)((Object)lookupSourceExecutionStrategy));
            }
        }
        throw new UnsupportedOperationException();
    }

    private static class SharedInternalJoinBridgeDataManager<T>
    implements InternalJoinBridgeDataManager<T> {
        private final T taskWideJoinBridge;
        private final BiFunction<T, Runnable, T> sharedWrapper;
        private final Map<Lifespan, T> map = new ConcurrentHashMap<Lifespan, T>();
        private final ReferenceCount referenceCount;

        public SharedInternalJoinBridgeDataManager(Function<Lifespan, T> lookupSourceFactoryProvider, BiFunction<T, Runnable, T> sharedWrapper, Consumer<T> destroy) {
            this.taskWideJoinBridge = lookupSourceFactoryProvider.apply(Lifespan.taskWide());
            this.referenceCount = new ReferenceCount(1);
            this.sharedWrapper = Objects.requireNonNull(sharedWrapper, "sharedWrapper is null");
            this.referenceCount.getFreeFuture().addListener(() -> destroy.accept(this.taskWideJoinBridge), MoreExecutors.directExecutor());
        }

        @Override
        public T get(Lifespan lifespan) {
            if (Lifespan.taskWide().equals(lifespan)) {
                return this.taskWideJoinBridge;
            }
            return (T)this.map.computeIfAbsent(lifespan, ignored -> {
                this.referenceCount.retain();
                return this.sharedWrapper.apply(this.taskWideJoinBridge, this.referenceCount::release);
            });
        }

        @Override
        public void noMoreLookupSourceFactory() {
            this.referenceCount.release();
        }
    }

    private static class OneToOneInternalJoinBridgeDataManager<T>
    implements InternalJoinBridgeDataManager<T> {
        private final Map<Lifespan, T> map = new ConcurrentHashMap<Lifespan, T>();
        private final Function<Lifespan, T> joinBridgeProvider;

        public OneToOneInternalJoinBridgeDataManager(Function<Lifespan, T> joinBridgeProvider) {
            this.joinBridgeProvider = joinBridgeProvider;
        }

        @Override
        public T get(Lifespan lifespan) {
            Preconditions.checkArgument((!Lifespan.taskWide().equals(lifespan) ? 1 : 0) != 0);
            return this.map.computeIfAbsent(lifespan, this.joinBridgeProvider);
        }
    }

    private static class TaskWideInternalJoinBridgeDataManager<T>
    implements InternalJoinBridgeDataManager<T> {
        private final Supplier<T> supplier = Suppliers.memoize(() -> lookupSourceFactoryProvider.apply(Lifespan.taskWide()));

        public TaskWideInternalJoinBridgeDataManager(Function<Lifespan, T> lookupSourceFactoryProvider) {
        }

        @Override
        public T get(Lifespan lifespan) {
            Preconditions.checkArgument((boolean)Lifespan.taskWide().equals(lifespan));
            return this.supplier.get();
        }
    }

    private static interface InternalJoinBridgeDataManager<T> {
        public T get(Lifespan var1);

        default public void noMoreLookupSourceFactory() {
        }
    }
}

