/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.array.LongBigArray;
import com.facebook.presto.operator.GroupByHash;
import com.facebook.presto.operator.GroupByIdBlock;
import com.facebook.presto.operator.HashGenerator;
import com.facebook.presto.operator.InterpretedHashGenerator;
import com.facebook.presto.operator.PagesHashStrategy;
import com.facebook.presto.operator.PrecomputedHashGenerator;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.operator.UpdateMemory;
import com.facebook.presto.operator.Work;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.DictionaryBlock;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.JoinCompiler;
import com.facebook.presto.util.HashCollisionsEstimator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.SizeOf;
import it.unimi.dsi.fastutil.HashCommon;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import org.openjdk.jol.info.ClassLayout;

public class MultiChannelGroupByHash
implements GroupByHash {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(MultiChannelGroupByHash.class).instanceSize();
    private static final float FILL_RATIO = 0.75f;
    private final List<Type> types;
    private final List<Type> hashTypes;
    private final int[] channels;
    private final PagesHashStrategy hashStrategy;
    private final List<ObjectArrayList<Block>> channelBuilders;
    private final Optional<Integer> inputHashChannel;
    private final HashGenerator hashGenerator;
    private final OptionalInt precomputedHashChannel;
    private final boolean processDictionary;
    private PageBuilder currentPageBuilder;
    private long completedPagesMemorySize;
    private int hashCapacity;
    private int maxFill;
    private int mask;
    private long[] groupAddressByHash;
    private int[] groupIdsByHash;
    private byte[] rawHashByHashPosition;
    private final LongBigArray groupAddressByGroupId;
    private int nextGroupId;
    private DictionaryLookBack dictionaryLookBack;
    private long hashCollisions;
    private double expectedHashCollisions;
    private final UpdateMemory updateMemory;
    private long preallocatedMemoryInBytes;
    private long currentPageSizeInBytes;

    public MultiChannelGroupByHash(List<? extends Type> hashTypes, int[] hashChannels, Optional<Integer> inputHashChannel, int expectedSize, boolean processDictionary, JoinCompiler joinCompiler, UpdateMemory updateMemory) {
        this.hashTypes = ImmutableList.copyOf((Collection)Objects.requireNonNull(hashTypes, "hashTypes is null"));
        Objects.requireNonNull(joinCompiler, "joinCompiler is null");
        Objects.requireNonNull(hashChannels, "hashChannels is null");
        Preconditions.checkArgument((hashTypes.size() == hashChannels.length ? 1 : 0) != 0, (Object)"hashTypes and hashChannels have different sizes");
        Preconditions.checkArgument((expectedSize > 0 ? 1 : 0) != 0, (Object)"expectedSize must be greater than zero");
        this.inputHashChannel = Objects.requireNonNull(inputHashChannel, "inputHashChannel is null");
        this.types = inputHashChannel.isPresent() ? ImmutableList.copyOf((Iterable)Iterables.concat(hashTypes, (Iterable)ImmutableList.of((Object)BigintType.BIGINT))) : this.hashTypes;
        this.channels = (int[])hashChannels.clone();
        this.hashGenerator = inputHashChannel.isPresent() ? new PrecomputedHashGenerator(inputHashChannel.get()) : new InterpretedHashGenerator(this.hashTypes, hashChannels);
        this.processDictionary = processDictionary;
        ImmutableList.Builder outputChannels = ImmutableList.builder();
        ImmutableList.Builder channelBuilders = ImmutableList.builder();
        for (int i = 0; i < hashChannels.length; ++i) {
            outputChannels.add((Object)i);
            channelBuilders.add((Object)ObjectArrayList.wrap((Object[])new Block[1024], (int)0));
        }
        if (inputHashChannel.isPresent()) {
            this.precomputedHashChannel = OptionalInt.of(hashChannels.length);
            channelBuilders.add((Object)ObjectArrayList.wrap((Object[])new Block[1024], (int)0));
        } else {
            this.precomputedHashChannel = OptionalInt.empty();
        }
        this.channelBuilders = channelBuilders.build();
        JoinCompiler.PagesHashStrategyFactory pagesHashStrategyFactory = joinCompiler.compilePagesHashStrategyFactory(this.types, (List<Integer>)outputChannels.build());
        this.hashStrategy = pagesHashStrategyFactory.createPagesHashStrategy(this.channelBuilders, this.precomputedHashChannel);
        this.startNewPage();
        this.hashCapacity = HashCommon.arraySize((int)expectedSize, (float)0.75f);
        this.maxFill = MultiChannelGroupByHash.calculateMaxFill(this.hashCapacity);
        this.mask = this.hashCapacity - 1;
        this.groupAddressByHash = new long[this.hashCapacity];
        Arrays.fill(this.groupAddressByHash, -1L);
        this.rawHashByHashPosition = new byte[this.hashCapacity];
        this.groupIdsByHash = new int[this.hashCapacity];
        this.groupAddressByGroupId = new LongBigArray();
        this.groupAddressByGroupId.ensureCapacity((long)this.maxFill);
        this.updateMemory = Objects.requireNonNull(updateMemory, "updateMemory is null");
    }

    @Override
    public long getRawHash(int groupId) {
        long address = this.groupAddressByGroupId.get((long)groupId);
        int blockIndex = SyntheticAddress.decodeSliceIndex(address);
        int position = SyntheticAddress.decodePosition(address);
        return this.hashStrategy.hashPosition(blockIndex, position);
    }

    @Override
    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + SizeOf.sizeOf((Object[])this.channelBuilders.get(0).elements()) * (long)this.channelBuilders.size() + this.completedPagesMemorySize + this.currentPageBuilder.getRetainedSizeInBytes() + SizeOf.sizeOf((long[])this.groupAddressByHash) + SizeOf.sizeOf((int[])this.groupIdsByHash) + this.groupAddressByGroupId.sizeOf() + SizeOf.sizeOf((byte[])this.rawHashByHashPosition) + this.preallocatedMemoryInBytes;
    }

    @Override
    public long getHashCollisions() {
        return this.hashCollisions;
    }

    @Override
    public double getExpectedHashCollisions() {
        return this.expectedHashCollisions + HashCollisionsEstimator.estimateNumberOfHashCollisions(this.getGroupCount(), this.hashCapacity);
    }

    @Override
    public List<Type> getTypes() {
        return this.types;
    }

    @Override
    public int getGroupCount() {
        return this.nextGroupId;
    }

    @Override
    public void appendValuesTo(int groupId, PageBuilder pageBuilder, int outputChannelOffset) {
        long address = this.groupAddressByGroupId.get((long)groupId);
        int blockIndex = SyntheticAddress.decodeSliceIndex(address);
        int position = SyntheticAddress.decodePosition(address);
        this.hashStrategy.appendTo(blockIndex, position, pageBuilder, outputChannelOffset);
    }

    @Override
    public Work<?> addPage(Page page) {
        this.currentPageSizeInBytes = page.getRetainedSizeInBytes();
        if (this.isRunLengthEncoded(page)) {
            return new AddRunLengthEncodedPageWork(page);
        }
        if (this.canProcessDictionary(page)) {
            return new AddDictionaryPageWork(page);
        }
        return new AddNonDictionaryPageWork(page);
    }

    @Override
    public Work<GroupByIdBlock> getGroupIds(Page page) {
        this.currentPageSizeInBytes = page.getRetainedSizeInBytes();
        if (this.isRunLengthEncoded(page)) {
            return new GetRunLengthEncodedGroupIdsWork(page);
        }
        if (this.canProcessDictionary(page)) {
            return new GetDictionaryGroupIdsWork(page);
        }
        return new GetNonDictionaryGroupIdsWork(page);
    }

    @Override
    public boolean contains(int position, Page page, int[] hashChannels) {
        long rawHash = this.hashStrategy.hashRow(position, page);
        int hashPosition = (int)MultiChannelGroupByHash.getHashPosition(rawHash, this.mask);
        while (this.groupAddressByHash[hashPosition] != -1L) {
            if (this.positionNotDistinctFromCurrentRow(this.groupAddressByHash[hashPosition], hashPosition, position, page, (byte)rawHash, hashChannels)) {
                return true;
            }
            hashPosition = hashPosition + 1 & this.mask;
        }
        return false;
    }

    @Override
    @VisibleForTesting
    public int getCapacity() {
        return this.hashCapacity;
    }

    private int putIfAbsent(int position, Page page) {
        long rawHash = this.hashGenerator.hashPosition(position, page);
        return this.putIfAbsent(position, page, rawHash);
    }

    private int putIfAbsent(int position, Page page, long rawHash) {
        int hashPosition = (int)MultiChannelGroupByHash.getHashPosition(rawHash, this.mask);
        int groupId = -1;
        while (this.groupAddressByHash[hashPosition] != -1L) {
            if (this.positionNotDistinctFromCurrentRow(this.groupAddressByHash[hashPosition], hashPosition, position, page, (byte)rawHash, this.channels)) {
                groupId = this.groupIdsByHash[hashPosition];
                break;
            }
            hashPosition = hashPosition + 1 & this.mask;
            ++this.hashCollisions;
        }
        if (groupId < 0) {
            groupId = this.addNewGroup(hashPosition, position, page, rawHash);
        }
        return groupId;
    }

    private int addNewGroup(int hashPosition, int position, Page page, long rawHash) {
        for (int i = 0; i < this.channels.length; ++i) {
            int hashChannel = this.channels[i];
            Type type = this.types.get(i);
            type.appendTo(page.getBlock(hashChannel), position, this.currentPageBuilder.getBlockBuilder(i));
        }
        if (this.precomputedHashChannel.isPresent()) {
            BigintType.BIGINT.writeLong(this.currentPageBuilder.getBlockBuilder(this.precomputedHashChannel.getAsInt()), rawHash);
        }
        this.currentPageBuilder.declarePosition();
        int pageIndex = this.channelBuilders.get(0).size() - 1;
        int pagePosition = this.currentPageBuilder.getPositionCount() - 1;
        long address = SyntheticAddress.encodeSyntheticAddress(pageIndex, pagePosition);
        int groupId = this.nextGroupId++;
        this.groupAddressByHash[hashPosition] = address;
        this.rawHashByHashPosition[hashPosition] = (byte)rawHash;
        this.groupIdsByHash[hashPosition] = groupId;
        this.groupAddressByGroupId.set((long)groupId, address);
        if (this.currentPageBuilder.isFull()) {
            this.startNewPage();
        }
        if (this.needRehash()) {
            this.tryRehash();
        }
        return groupId;
    }

    private boolean needRehash() {
        return this.nextGroupId >= this.maxFill;
    }

    private void startNewPage() {
        if (this.currentPageBuilder != null) {
            this.completedPagesMemorySize += this.currentPageBuilder.getRetainedSizeInBytes();
            this.currentPageBuilder = this.currentPageBuilder.newPageBuilderLike();
        } else {
            this.currentPageBuilder = new PageBuilder(this.types);
        }
        for (int i = 0; i < this.types.size(); ++i) {
            this.channelBuilders.get(i).add((Object)this.currentPageBuilder.getBlockBuilder(i));
        }
    }

    private boolean tryRehash() {
        long newCapacityLong = (long)this.hashCapacity * 2L;
        if (newCapacityLong > Integer.MAX_VALUE) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.GENERIC_INSUFFICIENT_RESOURCES, "Size of hash table cannot exceed 1 billion entries");
        }
        int newCapacity = Math.toIntExact(newCapacityLong);
        this.preallocatedMemoryInBytes = (long)(newCapacity - this.hashCapacity) * 13L + (long)((MultiChannelGroupByHash.calculateMaxFill(newCapacity) - this.maxFill) * 8) + this.currentPageSizeInBytes;
        if (!this.updateMemory.update()) {
            return false;
        }
        this.preallocatedMemoryInBytes = 0L;
        this.expectedHashCollisions += HashCollisionsEstimator.estimateNumberOfHashCollisions(this.getGroupCount(), this.hashCapacity);
        int newMask = newCapacity - 1;
        long[] newKey = new long[newCapacity];
        byte[] rawHashes = new byte[newCapacity];
        Arrays.fill(newKey, -1L);
        int[] newValue = new int[newCapacity];
        int oldIndex = 0;
        for (int groupId = 0; groupId < this.nextGroupId; ++groupId) {
            while (this.groupAddressByHash[oldIndex] == -1L) {
                ++oldIndex;
            }
            long address = this.groupAddressByHash[oldIndex];
            long rawHash = this.hashPosition(address);
            int pos = (int)MultiChannelGroupByHash.getHashPosition(rawHash, newMask);
            while (newKey[pos] != -1L) {
                pos = pos + 1 & newMask;
                ++this.hashCollisions;
            }
            newKey[pos] = address;
            rawHashes[pos] = (byte)rawHash;
            newValue[pos] = this.groupIdsByHash[oldIndex];
            ++oldIndex;
        }
        this.mask = newMask;
        this.hashCapacity = newCapacity;
        this.maxFill = MultiChannelGroupByHash.calculateMaxFill(newCapacity);
        this.groupAddressByHash = newKey;
        this.rawHashByHashPosition = rawHashes;
        this.groupIdsByHash = newValue;
        this.groupAddressByGroupId.ensureCapacity((long)this.maxFill);
        return true;
    }

    private long hashPosition(long sliceAddress) {
        int sliceIndex = SyntheticAddress.decodeSliceIndex(sliceAddress);
        int position = SyntheticAddress.decodePosition(sliceAddress);
        if (this.precomputedHashChannel.isPresent()) {
            return this.getRawHash(sliceIndex, position);
        }
        return this.hashStrategy.hashPosition(sliceIndex, position);
    }

    private long getRawHash(int sliceIndex, int position) {
        return ((Block)this.channelBuilders.get(this.precomputedHashChannel.getAsInt()).get(sliceIndex)).getLong(position, 0);
    }

    private boolean positionNotDistinctFromCurrentRow(long address, int hashPosition, int position, Page page, byte rawHash, int[] hashChannels) {
        if (this.rawHashByHashPosition[hashPosition] != rawHash) {
            return false;
        }
        return this.hashStrategy.positionNotDistinctFromRow(SyntheticAddress.decodeSliceIndex(address), SyntheticAddress.decodePosition(address), position, page, hashChannels);
    }

    private static long getHashPosition(long rawHash, int mask) {
        return HashCommon.murmurHash3((long)rawHash) & (long)mask;
    }

    private static int calculateMaxFill(int hashSize) {
        Preconditions.checkArgument((hashSize > 0 ? 1 : 0) != 0, (Object)"hashSize must be greater than 0");
        int maxFill = (int)Math.ceil((float)hashSize * 0.75f);
        if (maxFill == hashSize) {
            --maxFill;
        }
        Preconditions.checkArgument((hashSize > maxFill ? 1 : 0) != 0, (Object)"hashSize must be larger than maxFill");
        return maxFill;
    }

    private void updateDictionaryLookBack(Block dictionary) {
        if (this.dictionaryLookBack == null || this.dictionaryLookBack.getDictionary() != dictionary) {
            this.dictionaryLookBack = new DictionaryLookBack(dictionary);
        }
    }

    private Page createPageWithExtractedDictionary(Page page) {
        Block dictionary;
        Block[] blocks = new Block[page.getChannelCount()];
        blocks[this.channels[0]] = dictionary = ((DictionaryBlock)page.getBlock(this.channels[0])).getDictionary();
        if (this.inputHashChannel.isPresent()) {
            blocks[this.inputHashChannel.get().intValue()] = ((DictionaryBlock)page.getBlock(this.inputHashChannel.get().intValue())).getDictionary();
        }
        return new Page(dictionary.getPositionCount(), blocks);
    }

    private boolean canProcessDictionary(Page page) {
        if (!this.processDictionary || this.channels.length > 1 || !(page.getBlock(this.channels[0]) instanceof DictionaryBlock)) {
            return false;
        }
        if (this.inputHashChannel.isPresent()) {
            Block inputHashBlock = page.getBlock(this.inputHashChannel.get().intValue());
            DictionaryBlock inputDataBlock = (DictionaryBlock)page.getBlock(this.channels[0]);
            if (!(inputHashBlock instanceof DictionaryBlock)) {
                return false;
            }
            if (!((DictionaryBlock)inputHashBlock).getDictionarySourceId().equals((Object)inputDataBlock.getDictionarySourceId())) {
                return false;
            }
        }
        return true;
    }

    private boolean isRunLengthEncoded(Page page) {
        for (int i = 0; i < this.channels.length; ++i) {
            if (page.getBlock(this.channels[i]) instanceof RunLengthEncodedBlock) continue;
            return false;
        }
        return true;
    }

    private int getGroupId(HashGenerator hashGenerator, Page page, int positionInDictionary) {
        if (this.dictionaryLookBack.isProcessed(positionInDictionary)) {
            return this.dictionaryLookBack.getGroupId(positionInDictionary);
        }
        int groupId = this.putIfAbsent(positionInDictionary, page, hashGenerator.hashPosition(positionInDictionary, page));
        this.dictionaryLookBack.setProcessed(positionInDictionary, groupId);
        return groupId;
    }

    private class GetRunLengthEncodedGroupIdsWork
    implements Work<GroupByIdBlock> {
        private final Page page;
        int groupId = -1;
        private boolean processFinished;
        private boolean resultProduced;

        public GetRunLengthEncodedGroupIdsWork(Page page) {
            this.page = Objects.requireNonNull(page, "page is null");
        }

        @Override
        public boolean process() {
            Preconditions.checkState((!this.processFinished ? 1 : 0) != 0);
            if (this.page.getPositionCount() == 0) {
                this.processFinished = true;
                return true;
            }
            if (MultiChannelGroupByHash.this.needRehash() && !MultiChannelGroupByHash.this.tryRehash()) {
                return false;
            }
            this.groupId = MultiChannelGroupByHash.this.putIfAbsent(0, this.page);
            this.processFinished = true;
            return true;
        }

        @Override
        public GroupByIdBlock getResult() {
            Preconditions.checkState((boolean)this.processFinished);
            Preconditions.checkState((!this.resultProduced ? 1 : 0) != 0);
            this.resultProduced = true;
            return new GroupByIdBlock(MultiChannelGroupByHash.this.nextGroupId, (Block)new RunLengthEncodedBlock(BigintType.BIGINT.createFixedSizeBlockBuilder(1).writeLong((long)this.groupId).build(), this.page.getPositionCount()));
        }
    }

    private class GetDictionaryGroupIdsWork
    implements Work<GroupByIdBlock> {
        private final BlockBuilder blockBuilder;
        private final Page page;
        private final Page dictionaryPage;
        private final DictionaryBlock dictionaryBlock;
        private boolean finished;
        private int lastPosition;

        public GetDictionaryGroupIdsWork(Page page) {
            this.page = Objects.requireNonNull(page, "page is null");
            Verify.verify((boolean)MultiChannelGroupByHash.this.canProcessDictionary(page), (String)"invalid call to processDictionary", (Object[])new Object[0]);
            this.dictionaryBlock = (DictionaryBlock)page.getBlock(MultiChannelGroupByHash.this.channels[0]);
            MultiChannelGroupByHash.this.updateDictionaryLookBack(this.dictionaryBlock.getDictionary());
            this.dictionaryPage = MultiChannelGroupByHash.this.createPageWithExtractedDictionary(page);
            this.blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(page.getPositionCount());
        }

        @Override
        public boolean process() {
            int positionCount = this.page.getPositionCount();
            Preconditions.checkState((this.lastPosition < positionCount ? 1 : 0) != 0, (Object)"position count out of bound");
            Preconditions.checkState((!this.finished ? 1 : 0) != 0);
            if (MultiChannelGroupByHash.this.needRehash() && !MultiChannelGroupByHash.this.tryRehash()) {
                return false;
            }
            while (this.lastPosition < positionCount && !MultiChannelGroupByHash.this.needRehash()) {
                int positionInDictionary = this.dictionaryBlock.getId(this.lastPosition);
                int groupId = MultiChannelGroupByHash.this.getGroupId(MultiChannelGroupByHash.this.hashGenerator, this.dictionaryPage, positionInDictionary);
                BigintType.BIGINT.writeLong(this.blockBuilder, (long)groupId);
                ++this.lastPosition;
            }
            return this.lastPosition == positionCount;
        }

        @Override
        public GroupByIdBlock getResult() {
            Preconditions.checkState((this.lastPosition == this.page.getPositionCount() ? 1 : 0) != 0, (Object)"process has not yet finished");
            Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"result has produced");
            this.finished = true;
            return new GroupByIdBlock(MultiChannelGroupByHash.this.nextGroupId, this.blockBuilder.build());
        }
    }

    private class GetNonDictionaryGroupIdsWork
    implements Work<GroupByIdBlock> {
        private final BlockBuilder blockBuilder;
        private final Page page;
        private boolean finished;
        private int lastPosition;

        public GetNonDictionaryGroupIdsWork(Page page) {
            this.page = Objects.requireNonNull(page, "page is null");
            this.blockBuilder = BigintType.BIGINT.createFixedSizeBlockBuilder(page.getPositionCount());
        }

        @Override
        public boolean process() {
            int positionCount = this.page.getPositionCount();
            Preconditions.checkState((this.lastPosition <= positionCount ? 1 : 0) != 0, (Object)"position count out of bound");
            Preconditions.checkState((!this.finished ? 1 : 0) != 0);
            if (MultiChannelGroupByHash.this.needRehash() && !MultiChannelGroupByHash.this.tryRehash()) {
                return false;
            }
            while (this.lastPosition < positionCount && !MultiChannelGroupByHash.this.needRehash()) {
                BigintType.BIGINT.writeLong(this.blockBuilder, (long)MultiChannelGroupByHash.this.putIfAbsent(this.lastPosition, this.page));
                ++this.lastPosition;
            }
            return this.lastPosition == positionCount;
        }

        @Override
        public GroupByIdBlock getResult() {
            Preconditions.checkState((this.lastPosition == this.page.getPositionCount() ? 1 : 0) != 0, (Object)"process has not yet finished");
            Preconditions.checkState((!this.finished ? 1 : 0) != 0, (Object)"result has produced");
            this.finished = true;
            return new GroupByIdBlock(MultiChannelGroupByHash.this.nextGroupId, this.blockBuilder.build());
        }
    }

    private class AddRunLengthEncodedPageWork
    implements Work<Void> {
        private final Page page;
        private boolean finished;

        public AddRunLengthEncodedPageWork(Page page) {
            this.page = Objects.requireNonNull(page, "page is null");
        }

        @Override
        public boolean process() {
            Preconditions.checkState((!this.finished ? 1 : 0) != 0);
            if (this.page.getPositionCount() == 0) {
                this.finished = true;
                return true;
            }
            if (MultiChannelGroupByHash.this.needRehash() && !MultiChannelGroupByHash.this.tryRehash()) {
                return false;
            }
            MultiChannelGroupByHash.this.putIfAbsent(0, this.page);
            this.finished = true;
            return true;
        }

        @Override
        public Void getResult() {
            throw new UnsupportedOperationException();
        }
    }

    private class AddDictionaryPageWork
    implements Work<Void> {
        private final Page page;
        private final Page dictionaryPage;
        private final DictionaryBlock dictionaryBlock;
        private int lastPosition;

        public AddDictionaryPageWork(Page page) {
            Verify.verify((boolean)MultiChannelGroupByHash.this.canProcessDictionary(page), (String)"invalid call to addDictionaryPage", (Object[])new Object[0]);
            this.page = Objects.requireNonNull(page, "page is null");
            this.dictionaryBlock = (DictionaryBlock)page.getBlock(MultiChannelGroupByHash.this.channels[0]);
            MultiChannelGroupByHash.this.updateDictionaryLookBack(this.dictionaryBlock.getDictionary());
            this.dictionaryPage = MultiChannelGroupByHash.this.createPageWithExtractedDictionary(page);
        }

        @Override
        public boolean process() {
            int positionCount = this.page.getPositionCount();
            Preconditions.checkState((this.lastPosition < positionCount ? 1 : 0) != 0, (Object)"position count out of bound");
            if (MultiChannelGroupByHash.this.needRehash() && !MultiChannelGroupByHash.this.tryRehash()) {
                return false;
            }
            while (this.lastPosition < positionCount && !MultiChannelGroupByHash.this.needRehash()) {
                int positionInDictionary = this.dictionaryBlock.getId(this.lastPosition);
                MultiChannelGroupByHash.this.getGroupId(MultiChannelGroupByHash.this.hashGenerator, this.dictionaryPage, positionInDictionary);
                ++this.lastPosition;
            }
            return this.lastPosition == positionCount;
        }

        @Override
        public Void getResult() {
            throw new UnsupportedOperationException();
        }
    }

    private class AddNonDictionaryPageWork
    implements Work<Void> {
        private final Page page;
        private int lastPosition;

        public AddNonDictionaryPageWork(Page page) {
            this.page = Objects.requireNonNull(page, "page is null");
        }

        @Override
        public boolean process() {
            int positionCount = this.page.getPositionCount();
            Preconditions.checkState((this.lastPosition < positionCount ? 1 : 0) != 0, (Object)"position count out of bound");
            if (MultiChannelGroupByHash.this.needRehash() && !MultiChannelGroupByHash.this.tryRehash()) {
                return false;
            }
            while (this.lastPosition < positionCount && !MultiChannelGroupByHash.this.needRehash()) {
                MultiChannelGroupByHash.this.putIfAbsent(this.lastPosition, this.page);
                ++this.lastPosition;
            }
            return this.lastPosition == positionCount;
        }

        @Override
        public Void getResult() {
            throw new UnsupportedOperationException();
        }
    }

    private static final class DictionaryLookBack {
        private final Block dictionary;
        private final int[] processed;

        public DictionaryLookBack(Block dictionary) {
            this.dictionary = dictionary;
            this.processed = new int[dictionary.getPositionCount()];
            Arrays.fill(this.processed, -1);
        }

        public Block getDictionary() {
            return this.dictionary;
        }

        public int getGroupId(int position) {
            return this.processed[position];
        }

        public boolean isProcessed(int position) {
            return this.processed[position] != -1;
        }

        public void setProcessed(int position, int groupId) {
            this.processed[position] = groupId;
        }
    }
}

