/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.esri.core.geometry.Envelope;
import com.esri.core.geometry.ogc.OGCGeometry;
import com.facebook.presto.Session;
import com.facebook.presto.geospatial.serde.GeometrySerde;
import com.facebook.presto.operator.JoinFilterFunction;
import com.facebook.presto.operator.PagesSpatialIndex;
import com.facebook.presto.operator.SpatialIndexBuilderOperator;
import com.facebook.presto.operator.SyntheticAddress;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.JoinFilterFunctionCompiler;
import com.google.common.base.Verify;
import io.airlift.slice.Slice;
import it.unimi.dsi.fastutil.ints.IntArrayList;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalDouble;
import org.locationtech.jts.index.strtree.STRtree;
import org.openjdk.jol.info.ClassLayout;

public class PagesRTreeIndex
implements PagesSpatialIndex {
    private static final int[] EMPTY_ADDRESSES = new int[0];
    private final LongArrayList addresses;
    private final List<Type> types;
    private final List<Integer> outputChannels;
    private final List<List<Block>> channels;
    private final STRtree rtree;
    private final int radiusChannel;
    private final SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest;
    private final JoinFilterFunction filterFunction;

    public PagesRTreeIndex(Session session, LongArrayList addresses, List<Type> types, List<Integer> outputChannels, List<List<Block>> channels, STRtree rtree, Optional<Integer> radiusChannel, SpatialIndexBuilderOperator.SpatialPredicate spatialRelationshipTest, Optional<JoinFilterFunctionCompiler.JoinFilterFunctionFactory> filterFunctionFactory) {
        this.addresses = Objects.requireNonNull(addresses, "addresses is null");
        this.types = types;
        this.outputChannels = outputChannels;
        this.channels = Objects.requireNonNull(channels, "channels is null");
        this.rtree = Objects.requireNonNull(rtree, "rtree is null");
        this.radiusChannel = radiusChannel.orElse(-1);
        this.spatialRelationshipTest = Objects.requireNonNull(spatialRelationshipTest, "spatial relationship is null");
        this.filterFunction = filterFunctionFactory.map(factory -> factory.create(session.toConnectorSession(), addresses, channels)).orElse(null);
    }

    private static org.locationtech.jts.geom.Envelope getEnvelope(OGCGeometry ogcGeometry) {
        Envelope env = new Envelope();
        ogcGeometry.getEsriGeometry().queryEnvelope(env);
        return new org.locationtech.jts.geom.Envelope(env.getXMin(), env.getXMax(), env.getYMin(), env.getYMax());
    }

    @Override
    public int[] findJoinPositions(int probePosition, Page probe, int probeGeometryChannel) {
        Block probeGeometryBlock = probe.getBlock(probeGeometryChannel);
        if (probeGeometryBlock.isNull(probePosition)) {
            return EMPTY_ADDRESSES;
        }
        Slice slice = probeGeometryBlock.getSlice(probePosition, 0, probeGeometryBlock.getSliceLength(probePosition));
        OGCGeometry probeGeometry = GeometrySerde.deserialize((Slice)slice);
        Verify.verify((probeGeometry != null ? 1 : 0) != 0);
        if (probeGeometry.isEmpty()) {
            return EMPTY_ADDRESSES;
        }
        IntArrayList matchingPositions = new IntArrayList();
        org.locationtech.jts.geom.Envelope envelope = PagesRTreeIndex.getEnvelope(probeGeometry);
        if (this.radiusChannel == -1) {
            this.rtree.query(envelope, item -> {
                GeometryWithPosition geometryWithPosition = (GeometryWithPosition)item;
                if (this.spatialRelationshipTest.apply(geometryWithPosition.ogcGeometry, probeGeometry, OptionalDouble.empty())) {
                    matchingPositions.add(geometryWithPosition.position);
                }
            });
        } else {
            this.rtree.query(envelope, item -> {
                GeometryWithPosition geometryWithPosition = (GeometryWithPosition)item;
                if (this.spatialRelationshipTest.apply(geometryWithPosition.ogcGeometry, probeGeometry, OptionalDouble.of(this.getRadius(geometryWithPosition.position)))) {
                    matchingPositions.add(geometryWithPosition.position);
                }
            });
        }
        return matchingPositions.toIntArray(null);
    }

    private double getRadius(int joinPosition) {
        long joinAddress = this.addresses.getLong(joinPosition);
        int blockIndex = SyntheticAddress.decodeSliceIndex(joinAddress);
        int blockPosition = SyntheticAddress.decodePosition(joinAddress);
        return DoubleType.DOUBLE.getDouble(this.channels.get(this.radiusChannel).get(blockIndex), blockPosition);
    }

    @Override
    public boolean isJoinPositionEligible(int joinPosition, int probePosition, Page probe) {
        return this.filterFunction == null || this.filterFunction.filter(joinPosition, probePosition, probe);
    }

    @Override
    public void appendTo(int joinPosition, PageBuilder pageBuilder, int outputChannelOffset) {
        long joinAddress = this.addresses.getLong(joinPosition);
        int blockIndex = SyntheticAddress.decodeSliceIndex(joinAddress);
        int blockPosition = SyntheticAddress.decodePosition(joinAddress);
        for (int outputIndex : this.outputChannels) {
            Type type = this.types.get(outputIndex);
            List<Block> channel = this.channels.get(outputIndex);
            Block block = channel.get(blockIndex);
            type.appendTo(block, blockPosition, pageBuilder.getBlockBuilder(outputChannelOffset));
            ++outputChannelOffset;
        }
    }

    public static final class GeometryWithPosition {
        private static final int INSTANCE_SIZE = ClassLayout.parseClass(GeometryWithPosition.class).instanceSize();
        private final OGCGeometry ogcGeometry;
        private final int position;

        public GeometryWithPosition(OGCGeometry ogcGeometry, int position) {
            this.ogcGeometry = ogcGeometry;
            this.position = position;
        }

        public long getEstimatedMemorySizeInBytes() {
            return (long)INSTANCE_SIZE + this.ogcGeometry.estimateMemorySize();
        }
    }
}

