/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.LookupSource;
import com.facebook.presto.operator.LookupSourceFactory;
import com.facebook.presto.operator.LookupSourceProvider;
import com.facebook.presto.operator.OuterPositionIterator;
import com.facebook.presto.operator.PartitionedConsumption;
import com.facebook.presto.operator.SpilledLookupSourceHandle;
import com.facebook.presto.operator.TaskContext;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.planner.Symbol;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.OptionalInt;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Supplier;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public class SharedLookupSourceFactory
implements LookupSourceFactory {
    private final LookupSourceFactory delegate;
    private final Runnable onDestroy;
    private final AtomicBoolean destroyed = new AtomicBoolean(false);

    public SharedLookupSourceFactory(LookupSourceFactory delegate, Runnable onDestroy) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.onDestroy = Objects.requireNonNull(onDestroy, "onDestroy is null");
    }

    @Override
    public void destroy() {
        if (this.destroyed.compareAndSet(false, true)) {
            this.onDestroy.run();
        }
    }

    @Override
    public List<Type> getTypes() {
        return this.delegate.getTypes();
    }

    @Override
    public List<Type> getOutputTypes() {
        return this.delegate.getOutputTypes();
    }

    @Override
    public ListenableFuture<LookupSourceProvider> createLookupSourceProvider() {
        return this.delegate.createLookupSourceProvider();
    }

    @Override
    public int partitions() {
        return this.delegate.partitions();
    }

    @Override
    public ListenableFuture<PartitionedConsumption<Supplier<LookupSource>>> finishProbeOperator(OptionalInt lookupJoinsCount) {
        return this.delegate.finishProbeOperator(lookupJoinsCount);
    }

    @Override
    public OuterPositionIterator getOuterPositionIterator() {
        return this.delegate.getOuterPositionIterator();
    }

    @Override
    public Map<Symbol, Integer> getLayout() {
        return this.delegate.getLayout();
    }

    @Override
    public void setTaskContext(TaskContext taskContext) {
        this.delegate.setTaskContext(taskContext);
    }

    @Override
    public ListenableFuture<?> lendPartitionLookupSource(int partitionIndex, Supplier<LookupSource> partitionLookupSource) {
        return this.delegate.lendPartitionLookupSource(partitionIndex, partitionLookupSource);
    }

    @Override
    public void setPartitionSpilledLookupSourceHandle(int partitionIndex, SpilledLookupSourceHandle spilledLookupSourceHandle) {
        this.delegate.setPartitionSpilledLookupSourceHandle(partitionIndex, spilledLookupSourceHandle);
    }

    @Override
    public ListenableFuture<?> isDestroyed() {
        return this.delegate.isDestroyed();
    }
}

