/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.NestedLoopJoinPages;
import com.facebook.presto.operator.NestedLoopJoinPagesBridge;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.annotation.concurrent.ThreadSafe;

@ThreadSafe
public final class SharedNestedLoopJoinPagesBridge
implements NestedLoopJoinPagesBridge {
    private final NestedLoopJoinPagesBridge delegate;
    private final Runnable onDestroy;
    private final AtomicBoolean destroyed = new AtomicBoolean(false);

    public SharedNestedLoopJoinPagesBridge(NestedLoopJoinPagesBridge delegate, Runnable onDestroy) {
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        this.onDestroy = Objects.requireNonNull(onDestroy, "onDestroy is null");
    }

    @Override
    public ListenableFuture<NestedLoopJoinPages> getPagesFuture() {
        return this.delegate.getPagesFuture();
    }

    @Override
    public ListenableFuture<?> setPages(NestedLoopJoinPages nestedLoopJoinPages) {
        return this.delegate.setPages(nestedLoopJoinPages);
    }

    @Override
    public void destroy() {
        if (this.destroyed.compareAndSet(false, true)) {
            this.onDestroy.run();
        }
    }
}

