/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.PageWithPositionComparator;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.type.Type;
import com.google.common.collect.ImmutableList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class SimplePageWithPositionComparator
implements PageWithPositionComparator {
    private final List<Integer> sortChannels;
    private final List<SortOrder> sortOrders;
    private final List<Type> types;

    public SimplePageWithPositionComparator(List<Type> types, List<Integer> sortChannels, List<SortOrder> sortOrders) {
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        this.sortChannels = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortChannels, "sortChannels is null"));
        this.sortOrders = ImmutableList.copyOf((Collection)Objects.requireNonNull(sortOrders, "sortOrders is null"));
    }

    @Override
    public int compareTo(Page left, int leftPosition, Page right, int rightPosition) {
        for (int i = 0; i < this.sortChannels.size(); ++i) {
            int sortChannel = this.sortChannels.get(i);
            Block leftBlock = left.getBlock(sortChannel);
            Block rightBlock = right.getBlock(sortChannel);
            SortOrder sortOrder = this.sortOrders.get(i);
            int compare = sortOrder.compareBlockValue(this.types.get(sortChannel), leftBlock, leftPosition, rightBlock, rightPosition);
            if (compare == 0) continue;
            return compare;
        }
        return 0;
    }
}

