/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.Session;
import com.facebook.presto.memory.context.LocalMemoryContext;
import com.facebook.presto.operator.DriverContext;
import com.facebook.presto.operator.Operator;
import com.facebook.presto.operator.OperatorContext;
import com.facebook.presto.operator.OperatorFactory;
import com.facebook.presto.operator.OperatorInfo;
import com.facebook.presto.spi.ConnectorPageSink;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.PageBuilder;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.RunLengthEncodedBlock;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarbinaryType;
import com.facebook.presto.split.PageSinkManager;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.util.AutoCloseableCloser;
import com.facebook.presto.util.Mergeable;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import io.airlift.concurrent.MoreFutures;
import io.airlift.slice.Slice;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicLong;

public class TableWriterOperator
implements Operator {
    public static final int ROW_COUNT_CHANNEL = 0;
    public static final int FRAGMENT_CHANNEL = 1;
    private static final int WRITER_CHANNELS = 2;
    private final OperatorContext operatorContext;
    private final LocalMemoryContext pageSinkMemoryContext;
    private final ConnectorPageSink pageSink;
    private final List<Integer> columnChannels;
    private final AtomicLong pageSinkPeakMemoryUsage = new AtomicLong();
    private final Operator statisticAggregationOperator;
    private final List<Type> types;
    private ListenableFuture<?> blocked = NOT_BLOCKED;
    private CompletableFuture<Collection<Slice>> finishFuture;
    private State state = State.RUNNING;
    private long rowCount;
    private boolean committed;
    private boolean closed;
    private long writtenBytes;

    public TableWriterOperator(OperatorContext operatorContext, ConnectorPageSink pageSink, List<Integer> columnChannels, Operator statisticAggregationOperator, List<Type> types) {
        this.operatorContext = Objects.requireNonNull(operatorContext, "operatorContext is null");
        this.pageSinkMemoryContext = operatorContext.newLocalSystemMemoryContext(TableWriterOperator.class.getSimpleName());
        this.pageSink = Objects.requireNonNull(pageSink, "pageSink is null");
        this.columnChannels = Objects.requireNonNull(columnChannels, "columnChannels is null");
        this.operatorContext.setInfoSupplier(this::getInfo);
        this.statisticAggregationOperator = Objects.requireNonNull(statisticAggregationOperator, "statisticAggregationOperator is null");
        this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public void finish() {
        ListenableFuture<?> currentlyBlocked = this.blocked;
        this.statisticAggregationOperator.finish();
        ListenableFuture<?> blockedOnAggregation = this.statisticAggregationOperator.isBlocked();
        ListenableFuture blockedOnFinish = NOT_BLOCKED;
        if (this.state == State.RUNNING) {
            this.state = State.FINISHING;
            this.finishFuture = this.pageSink.finish();
            blockedOnFinish = MoreFutures.toListenableFuture(this.finishFuture);
            this.updateWrittenBytes();
        }
        this.blocked = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{currentlyBlocked, blockedOnAggregation, blockedOnFinish});
    }

    @Override
    public boolean isFinished() {
        return this.state == State.FINISHED && this.blocked.isDone();
    }

    @Override
    public ListenableFuture<?> isBlocked() {
        return this.blocked;
    }

    @Override
    public boolean needsInput() {
        if (this.state != State.RUNNING || !this.blocked.isDone()) {
            return false;
        }
        return this.statisticAggregationOperator.needsInput();
    }

    @Override
    public void addInput(Page page) {
        Objects.requireNonNull(page, "page is null");
        Preconditions.checkState((boolean)this.needsInput(), (Object)"Operator does not need input");
        Block[] blocks = new Block[this.columnChannels.size()];
        for (int outputChannel = 0; outputChannel < this.columnChannels.size(); ++outputChannel) {
            blocks[outputChannel] = page.getBlock(this.columnChannels.get(outputChannel).intValue());
        }
        this.statisticAggregationOperator.addInput(page);
        ListenableFuture<?> blockedOnAggregation = this.statisticAggregationOperator.isBlocked();
        CompletableFuture future = this.pageSink.appendPage(new Page(blocks));
        this.updateMemoryUsage();
        ListenableFuture blockedOnWrite = MoreFutures.toListenableFuture((CompletableFuture)future);
        this.blocked = Futures.allAsList((ListenableFuture[])new ListenableFuture[]{blockedOnAggregation, blockedOnWrite});
        this.rowCount += (long)page.getPositionCount();
        this.updateWrittenBytes();
    }

    @Override
    public Page getOutput() {
        if (!this.blocked.isDone()) {
            return null;
        }
        if (!this.statisticAggregationOperator.isFinished()) {
            Page aggregationOutput = this.statisticAggregationOperator.getOutput();
            if (aggregationOutput == null) {
                return null;
            }
            return this.createStatisticsPage(aggregationOutput);
        }
        if (this.state != State.FINISHING) {
            return null;
        }
        Page fragmentsPage = this.createFragmentsPage();
        int positionCount = fragmentsPage.getPositionCount();
        Block[] outputBlocks = new Block[this.types.size()];
        for (int channel = 0; channel < this.types.size(); ++channel) {
            outputBlocks[channel] = channel < 2 ? fragmentsPage.getBlock(channel) : RunLengthEncodedBlock.create((Type)this.types.get(channel), null, (int)positionCount);
        }
        this.state = State.FINISHED;
        return new Page(positionCount, outputBlocks);
    }

    private Page createStatisticsPage(Page aggregationOutput) {
        int positionCount = aggregationOutput.getPositionCount();
        Block[] outputBlocks = new Block[this.types.size()];
        for (int channel = 0; channel < this.types.size(); ++channel) {
            outputBlocks[channel] = channel < 2 ? RunLengthEncodedBlock.create((Type)this.types.get(channel), null, (int)positionCount) : aggregationOutput.getBlock(channel - 2);
        }
        return new Page(positionCount, outputBlocks);
    }

    private Page createFragmentsPage() {
        Collection fragments = (Collection)MoreFutures.getFutureValue(this.finishFuture);
        this.committed = true;
        this.updateWrittenBytes();
        PageBuilder page = new PageBuilder(fragments.size() + 1, (List)ImmutableList.of((Object)this.types.get(0), (Object)this.types.get(1)));
        BlockBuilder rowsBuilder = page.getBlockBuilder(0);
        BlockBuilder fragmentBuilder = page.getBlockBuilder(1);
        page.declarePosition();
        BigintType.BIGINT.writeLong(rowsBuilder, this.rowCount);
        fragmentBuilder.appendNull();
        for (Slice fragment : fragments) {
            page.declarePosition();
            rowsBuilder.appendNull();
            VarbinaryType.VARBINARY.writeSlice(fragmentBuilder, fragment);
        }
        return page.build();
    }

    @Override
    public void close() throws Exception {
        AutoCloseableCloser closer = AutoCloseableCloser.create();
        if (!this.closed) {
            this.closed = true;
            if (!this.committed) {
                closer.register(() -> ((ConnectorPageSink)this.pageSink).abort());
            }
        }
        closer.register(this.statisticAggregationOperator);
        closer.register(() -> this.pageSinkMemoryContext.close());
        closer.close();
    }

    private void updateWrittenBytes() {
        long current = this.pageSink.getCompletedBytes();
        this.operatorContext.recordPhysicalWrittenData(current - this.writtenBytes);
        this.writtenBytes = current;
    }

    private void updateMemoryUsage() {
        long pageSinkMemoryUsage = this.pageSink.getSystemMemoryUsage();
        this.pageSinkMemoryContext.setBytes(pageSinkMemoryUsage);
        this.pageSinkPeakMemoryUsage.accumulateAndGet(pageSinkMemoryUsage, Math::max);
    }

    @VisibleForTesting
    Operator getStatisticAggregationOperator() {
        return this.statisticAggregationOperator;
    }

    @VisibleForTesting
    TableWriterInfo getInfo() {
        return new TableWriterInfo(this.pageSinkPeakMemoryUsage.get());
    }

    public static class TableWriterInfo
    implements Mergeable<TableWriterInfo>,
    OperatorInfo {
        private final long pageSinkPeakMemoryUsage;

        @JsonCreator
        public TableWriterInfo(@JsonProperty(value="pageSinkPeakMemoryUsage") long pageSinkPeakMemoryUsage) {
            this.pageSinkPeakMemoryUsage = pageSinkPeakMemoryUsage;
        }

        @JsonProperty
        public long getPageSinkPeakMemoryUsage() {
            return this.pageSinkPeakMemoryUsage;
        }

        @Override
        public TableWriterInfo mergeWith(TableWriterInfo other) {
            return new TableWriterInfo(Math.max(this.pageSinkPeakMemoryUsage, other.pageSinkPeakMemoryUsage));
        }

        @Override
        public boolean isFinal() {
            return true;
        }

        public String toString() {
            return MoreObjects.toStringHelper((Object)this).add("pageSinkPeakMemoryUsage", this.pageSinkPeakMemoryUsage).toString();
        }
    }

    private static enum State {
        RUNNING,
        FINISHING,
        FINISHED;

    }

    public static class TableWriterOperatorFactory
    implements OperatorFactory {
        private final int operatorId;
        private final PlanNodeId planNodeId;
        private final PageSinkManager pageSinkManager;
        private final TableWriterNode.WriterTarget target;
        private final List<Integer> columnChannels;
        private final Session session;
        private final OperatorFactory statisticsAggregationOperatorFactory;
        private final List<Type> types;
        private boolean closed;

        public TableWriterOperatorFactory(int operatorId, PlanNodeId planNodeId, PageSinkManager pageSinkManager, TableWriterNode.WriterTarget writerTarget, List<Integer> columnChannels, Session session, OperatorFactory statisticsAggregationOperatorFactory, List<Type> types) {
            this.operatorId = operatorId;
            this.planNodeId = Objects.requireNonNull(planNodeId, "planNodeId is null");
            this.columnChannels = Objects.requireNonNull(columnChannels, "columnChannels is null");
            this.pageSinkManager = Objects.requireNonNull(pageSinkManager, "pageSinkManager is null");
            Preconditions.checkArgument((writerTarget instanceof TableWriterNode.CreateHandle || writerTarget instanceof TableWriterNode.InsertHandle ? 1 : 0) != 0, (Object)"writerTarget must be CreateHandle or InsertHandle");
            this.target = Objects.requireNonNull(writerTarget, "writerTarget is null");
            this.session = session;
            this.statisticsAggregationOperatorFactory = Objects.requireNonNull(statisticsAggregationOperatorFactory, "statisticsAggregationOperatorFactory is null");
            this.types = ImmutableList.copyOf((Collection)Objects.requireNonNull(types, "types is null"));
        }

        @Override
        public Operator createOperator(DriverContext driverContext) {
            Preconditions.checkState((!this.closed ? 1 : 0) != 0, (Object)"Factory is already closed");
            OperatorContext context = driverContext.addOperatorContext(this.operatorId, this.planNodeId, TableWriterOperator.class.getSimpleName());
            return new TableWriterOperator(context, this.createPageSink(), this.columnChannels, this.statisticsAggregationOperatorFactory.createOperator(driverContext), this.types);
        }

        private ConnectorPageSink createPageSink() {
            if (this.target instanceof TableWriterNode.CreateHandle) {
                return this.pageSinkManager.createPageSink(this.session, ((TableWriterNode.CreateHandle)this.target).getHandle());
            }
            if (this.target instanceof TableWriterNode.InsertHandle) {
                return this.pageSinkManager.createPageSink(this.session, ((TableWriterNode.InsertHandle)this.target).getHandle());
            }
            throw new UnsupportedOperationException("Unhandled target type: " + this.target.getClass().getName());
        }

        @Override
        public void noMoreOperators() {
            this.closed = true;
        }

        @Override
        public OperatorFactory duplicate() {
            return new TableWriterOperatorFactory(this.operatorId, this.planNodeId, this.pageSinkManager, this.target, this.columnChannels, this.session, this.statisticsAggregationOperatorFactory, this.types);
        }
    }
}

