/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator;

import com.facebook.presto.operator.WorkProcessorUtils;
import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.concurrent.Immutable;

public interface WorkProcessor<T> {
    public boolean process();

    public boolean isBlocked();

    public ListenableFuture<?> getBlockedFuture();

    public boolean isFinished();

    public T getResult();

    default public <R> WorkProcessor<R> flatMap(Function<T, WorkProcessor<R>> mapper) {
        return WorkProcessorUtils.flatMap(this, mapper);
    }

    default public <R> WorkProcessor<R> map(Function<T, R> mapper) {
        return WorkProcessorUtils.map(this, mapper);
    }

    default public <R> WorkProcessor<R> flatTransform(Transformation<T, WorkProcessor<R>> transformation) {
        return WorkProcessorUtils.flatTransform(this, transformation);
    }

    default public <R> WorkProcessor<R> transform(Transformation<T, R> transformation) {
        return WorkProcessorUtils.transform(this, transformation);
    }

    default public <R> WorkProcessor<R> transformProcessor(Function<WorkProcessor<T>, WorkProcessor<R>> transformation) {
        return transformation.apply(this);
    }

    default public Iterator<T> iterator() {
        return WorkProcessorUtils.iteratorFrom(this);
    }

    default public Iterator<Optional<T>> yieldingIterator() {
        return WorkProcessorUtils.yieldingIteratorFrom(this);
    }

    public static <T> WorkProcessor<T> flatten(WorkProcessor<WorkProcessor<T>> processor) {
        return WorkProcessorUtils.flatten(processor);
    }

    public static <T> WorkProcessor<T> fromIterable(Iterable<T> iterable) {
        return WorkProcessorUtils.fromIterator(iterable.iterator());
    }

    public static <T> WorkProcessor<T> fromIterator(Iterator<T> iterator) {
        return WorkProcessorUtils.fromIterator(iterator);
    }

    public static <T> WorkProcessor<T> create(Process<T> process) {
        return WorkProcessorUtils.create(process);
    }

    public static <T> WorkProcessor<T> mergeSorted(Iterable<WorkProcessor<T>> processorIterable, Comparator<T> comparator) {
        return WorkProcessorUtils.mergeSorted(processorIterable, comparator);
    }

    @Immutable
    public static final class ProcessorState<T> {
        private static final ProcessorState NEEDS_MORE_DATE_STATE = new ProcessorState(Type.NEEDS_MORE_DATA, true, Optional.empty(), Optional.empty());
        private static final ProcessorState YIELD_STATE = new ProcessorState(Type.YIELD, false, Optional.empty(), Optional.empty());
        private static final ProcessorState FINISHED_STATE = new ProcessorState(Type.FINISHED, false, Optional.empty(), Optional.empty());
        private final Type type;
        private final boolean needsMoreData;
        private final Optional<T> result;
        private final Optional<ListenableFuture<?>> blocked;

        ProcessorState(Type type, boolean needsMoreData, Optional<T> result, Optional<ListenableFuture<?>> blocked) {
            this.type = Objects.requireNonNull(type, "type is null");
            this.needsMoreData = needsMoreData;
            this.result = Objects.requireNonNull(result, "result is null");
            this.blocked = Objects.requireNonNull(blocked, "blocked is null");
            Preconditions.checkArgument((!needsMoreData || type == Type.NEEDS_MORE_DATA || type == Type.RESULT ? 1 : 0) != 0);
            Preconditions.checkArgument((!blocked.isPresent() || type == Type.BLOCKED ? 1 : 0) != 0);
            Preconditions.checkArgument((!result.isPresent() || type == Type.RESULT ? 1 : 0) != 0);
        }

        public static <T> ProcessorState<T> needsMoreData() {
            return NEEDS_MORE_DATE_STATE;
        }

        public static <T> ProcessorState<T> blocked(ListenableFuture<?> blocked) {
            return new ProcessorState(Type.BLOCKED, false, Optional.empty(), Optional.of(blocked));
        }

        public static <T> ProcessorState<T> yield() {
            return YIELD_STATE;
        }

        public static <T> ProcessorState<T> ofResult(T result) {
            return ProcessorState.ofResult(result, true);
        }

        public static <T> ProcessorState<T> ofResult(T result, boolean needsMoreData) {
            return new ProcessorState<T>(Type.RESULT, needsMoreData, Optional.of(result), Optional.empty());
        }

        public static <T> ProcessorState<T> finished() {
            return FINISHED_STATE;
        }

        Type getType() {
            return this.type;
        }

        boolean isNeedsMoreData() {
            return this.needsMoreData;
        }

        Optional<T> getResult() {
            return this.result;
        }

        Optional<ListenableFuture<?>> getBlocked() {
            return this.blocked;
        }

        static enum Type {
            NEEDS_MORE_DATA,
            BLOCKED,
            YIELD,
            RESULT,
            FINISHED;

        }
    }

    public static interface Process<T> {
        public ProcessorState<T> process();
    }

    public static interface Transformation<T, R> {
        public ProcessorState<R> process(Optional<T> var1);
    }
}

