/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.arrayagg;

import com.facebook.presto.operator.aggregation.arrayagg.ArrayAggGroupImplementation;
import com.facebook.presto.operator.aggregation.arrayagg.ArrayAggregationState;
import com.facebook.presto.operator.aggregation.arrayagg.GroupArrayAggregationState;
import com.facebook.presto.operator.aggregation.arrayagg.LegacyArrayAggregationGroupState;
import com.facebook.presto.operator.aggregation.arrayagg.SingleArrayAggregationState;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.AccumulatorStateFactory;
import com.facebook.presto.spi.type.Type;

public class ArrayAggregationStateFactory
implements AccumulatorStateFactory<ArrayAggregationState> {
    private final Type type;
    private final ArrayAggGroupImplementation mode;

    public ArrayAggregationStateFactory(Type type, ArrayAggGroupImplementation mode) {
        this.type = type;
        this.mode = mode;
    }

    public ArrayAggregationState createSingleState() {
        return new SingleArrayAggregationState(this.type);
    }

    public Class<? extends ArrayAggregationState> getSingleStateClass() {
        return SingleArrayAggregationState.class;
    }

    public ArrayAggregationState createGroupedState() {
        switch (this.mode) {
            case NEW: {
                return new GroupArrayAggregationState(this.type);
            }
            case LEGACY: {
                return new LegacyArrayAggregationGroupState(this.type);
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("Unexpected group enum type %s", new Object[]{this.mode}));
    }

    public Class<? extends ArrayAggregationState> getGroupedStateClass() {
        switch (this.mode) {
            case NEW: {
                return GroupArrayAggregationState.class;
            }
            case LEGACY: {
                return LegacyArrayAggregationGroupState.class;
            }
        }
        throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.FUNCTION_IMPLEMENTATION_ERROR, String.format("Unexpected group enum type %s", new Object[]{this.mode}));
    }
}

