/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.aggregation.arrayagg;

import com.facebook.presto.array.IntBigArray;
import com.facebook.presto.array.ShortBigArray;
import com.facebook.presto.operator.aggregation.arrayagg.ArrayAggregationState;
import com.facebook.presto.operator.aggregation.arrayagg.ArrayAggregationStateConsumer;
import com.facebook.presto.operator.aggregation.state.AbstractGroupedAccumulatorState;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.PageBuilderStatus;
import com.facebook.presto.spi.type.Type;
import com.google.common.base.Verify;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.util.ArrayList;
import java.util.List;
import org.openjdk.jol.info.ClassLayout;

public class GroupArrayAggregationState
extends AbstractGroupedAccumulatorState
implements ArrayAggregationState {
    private static final int INSTANCE_SIZE = ClassLayout.parseClass(GroupArrayAggregationState.class).instanceSize();
    private static final int MAX_BLOCK_SIZE = 0x100000;
    private static final int MAX_NUM_BLOCKS = 30000;
    private static final short NULL = -1;
    private final Type type;
    private final ShortBigArray headBlockIndex;
    private final IntBigArray headPosition;
    private final ShortBigArray nextBlockIndex;
    private final IntBigArray nextPosition;
    private final ShortBigArray tailBlockIndex;
    private final IntBigArray tailPosition;
    private final List<BlockBuilder> values;
    private final LongList sumPositions;
    private BlockBuilder currentBlockBuilder;
    private PageBuilderStatus pageBuilderStatus;
    private long valueBlocksRetainedSizeInBytes;
    private long totalPositions;
    private long capacity;

    public GroupArrayAggregationState(Type type) {
        this.type = type;
        this.headBlockIndex = new ShortBigArray(-1);
        this.headPosition = new IntBigArray(-1);
        this.nextBlockIndex = new ShortBigArray(-1);
        this.nextPosition = new IntBigArray(-1);
        this.tailBlockIndex = new ShortBigArray(-1);
        this.tailPosition = new IntBigArray(-1);
        this.pageBuilderStatus = new PageBuilderStatus(0x100000);
        this.currentBlockBuilder = type.createBlockBuilder(this.pageBuilderStatus.createBlockBuilderStatus(), 16);
        this.values = new ArrayList<BlockBuilder>();
        this.sumPositions = new LongArrayList();
        this.values.add(this.currentBlockBuilder);
        this.sumPositions.add(0L);
        this.valueBlocksRetainedSizeInBytes = 0L;
        this.totalPositions = 0L;
        this.capacity = 1024L;
        this.nextBlockIndex.ensureCapacity(this.capacity);
        this.nextPosition.ensureCapacity(this.capacity);
    }

    public void ensureCapacity(long size) {
        this.headBlockIndex.ensureCapacity(size);
        this.headPosition.ensureCapacity(size);
        this.tailBlockIndex.ensureCapacity(size);
        this.tailPosition.ensureCapacity(size);
    }

    public long getEstimatedSize() {
        return (long)INSTANCE_SIZE + this.headBlockIndex.sizeOf() + this.headPosition.sizeOf() + this.tailBlockIndex.sizeOf() + this.tailPosition.sizeOf() + this.nextBlockIndex.sizeOf() + this.nextPosition.sizeOf() + this.valueBlocksRetainedSizeInBytes + this.currentBlockBuilder.getRetainedSizeInBytes();
    }

    @Override
    public void add(Block block, int position) {
        long currentGroupId = this.getGroupId();
        short insertedBlockIndex = (short)(this.values.size() - 1);
        int insertedPosition = this.currentBlockBuilder.getPositionCount();
        if (this.totalPositions == this.capacity) {
            this.capacity = (long)((double)this.capacity * 1.5);
            this.nextBlockIndex.ensureCapacity(this.capacity);
            this.nextPosition.ensureCapacity(this.capacity);
        }
        if (this.isEmpty()) {
            this.headBlockIndex.set(currentGroupId, insertedBlockIndex);
            this.headPosition.set(currentGroupId, insertedPosition);
        } else {
            long absoluteTailAddress = this.toAbsolutePosition(this.tailBlockIndex.get(currentGroupId), this.tailPosition.get(currentGroupId));
            this.nextBlockIndex.set(absoluteTailAddress, insertedBlockIndex);
            this.nextPosition.set(absoluteTailAddress, insertedPosition);
        }
        this.tailBlockIndex.set(currentGroupId, insertedBlockIndex);
        this.tailPosition.set(currentGroupId, insertedPosition);
        this.type.appendTo(block, position, this.currentBlockBuilder);
        ++this.totalPositions;
        if (this.pageBuilderStatus.isFull()) {
            this.valueBlocksRetainedSizeInBytes += this.currentBlockBuilder.getRetainedSizeInBytes();
            this.sumPositions.add(this.totalPositions);
            this.pageBuilderStatus = new PageBuilderStatus(0x100000);
            this.currentBlockBuilder = this.currentBlockBuilder.newBlockBuilderLike(this.pageBuilderStatus.createBlockBuilderStatus());
            this.values.add(this.currentBlockBuilder);
            Verify.verify((this.values.size() <= 30000 ? 1 : 0) != 0);
        }
    }

    @Override
    public void forEach(ArrayAggregationStateConsumer consumer) {
        short currentBlockId = this.headBlockIndex.get(this.getGroupId());
        int currentPosition = this.headPosition.get(this.getGroupId());
        while (currentBlockId != -1) {
            consumer.accept((Block)this.values.get(currentBlockId), currentPosition);
            long absoluteCurrentAddress = this.toAbsolutePosition(currentBlockId, currentPosition);
            currentBlockId = this.nextBlockIndex.get(absoluteCurrentAddress);
            currentPosition = this.nextPosition.get(absoluteCurrentAddress);
        }
    }

    @Override
    public boolean isEmpty() {
        return this.headBlockIndex.get(this.getGroupId()) == -1;
    }

    private long toAbsolutePosition(short blockId, int position) {
        return (Long)this.sumPositions.get((int)blockId) + (long)position;
    }
}

