/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.exchange;

import com.facebook.presto.operator.exchange.LocalExchangeMemoryManager;
import com.facebook.presto.operator.exchange.LocalExchanger;
import com.facebook.presto.operator.exchange.PageReference;
import com.facebook.presto.spi.Page;
import com.google.common.collect.ImmutableList;
import com.google.common.util.concurrent.ListenableFuture;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;

class BroadcastExchanger
implements LocalExchanger {
    private final List<Consumer<PageReference>> buffers;
    private final LocalExchangeMemoryManager memoryManager;

    public BroadcastExchanger(List<Consumer<PageReference>> buffers, LocalExchangeMemoryManager memoryManager) {
        this.buffers = ImmutableList.copyOf((Collection)Objects.requireNonNull(buffers, "buffers is null"));
        this.memoryManager = Objects.requireNonNull(memoryManager, "memoryManager is null");
    }

    @Override
    public void accept(Page page) {
        this.memoryManager.updateMemoryUsage(page.getRetainedSizeInBytes());
        PageReference pageReference = new PageReference(page, this.buffers.size(), () -> this.memoryManager.updateMemoryUsage(-page.getRetainedSizeInBytes()));
        for (Consumer<PageReference> buffer : this.buffers) {
            buffer.accept(pageReference);
        }
    }

    @Override
    public ListenableFuture<?> waitForWriting() {
        return this.memoryManager.getNotFullFuture();
    }
}

