/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.project;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.operator.project.InputChannels;
import com.facebook.presto.operator.project.PageFilter;
import com.facebook.presto.operator.project.SelectedPositions;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.analyzer.ExpressionAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.planner.DeterminismEvaluator;
import com.facebook.presto.sql.planner.ExpressionInterpreter;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SymbolToInputParameterRewriter;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.NodeRef;
import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class InterpretedPageFilter
implements PageFilter {
    private final ExpressionInterpreter evaluator;
    private final InputChannels inputChannels;
    private final boolean deterministic;
    private boolean[] selectedPositions = new boolean[0];

    public InterpretedPageFilter(Expression expression, TypeProvider symbolTypes, Map<Symbol, Integer> symbolToInputMappings, Metadata metadata, SqlParser sqlParser, Session session) {
        SymbolToInputParameterRewriter rewriter = new SymbolToInputParameterRewriter(symbolTypes, symbolToInputMappings);
        Expression rewritten = rewriter.rewrite(expression);
        this.inputChannels = new InputChannels(rewriter.getInputChannels());
        this.deterministic = DeterminismEvaluator.isDeterministic(expression);
        List<Type> inputTypes = rewriter.getInputTypes();
        ImmutableMap.Builder parameterTypes = ImmutableMap.builder();
        for (int parameter = 0; parameter < inputTypes.size(); ++parameter) {
            Type type = inputTypes.get(parameter);
            parameterTypes.put((Object)parameter, (Object)type);
        }
        Map<NodeRef<Expression>, Type> expressionTypes = ExpressionAnalyzer.getExpressionTypesFromInput(session, metadata, sqlParser, (Map<Integer, Type>)parameterTypes.build(), rewritten, Collections.emptyList());
        this.evaluator = ExpressionInterpreter.expressionInterpreter(rewritten, metadata, session, expressionTypes);
    }

    @Override
    public boolean isDeterministic() {
        return this.deterministic;
    }

    @Override
    public InputChannels getInputChannels() {
        return this.inputChannels;
    }

    @Override
    public SelectedPositions filter(ConnectorSession session, Page page) {
        if (this.selectedPositions.length < page.getPositionCount()) {
            this.selectedPositions = new boolean[page.getPositionCount()];
        }
        for (int position = 0; position < page.getPositionCount(); ++position) {
            this.selectedPositions[position] = this.filter(page, position);
        }
        return PageFilter.positionsArrayToSelectedPositions(this.selectedPositions, page.getPositionCount());
    }

    private boolean filter(Page page, int position) {
        return Boolean.TRUE.equals(this.evaluator.evaluate(position, page));
    }
}

