/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlNullable;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.util.Failures;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;

@Description(value="Determines whether given value exists in the array")
@ScalarFunction(value="contains")
public final class ArrayContains {
    private ArrayContains() {
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean contains(@TypeParameter(value="T") Type elementType, @OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle equals, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") Block value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                Boolean result = equals.invokeExact((Block)elementType.getObject(arrayBlock, i), value);
                ArrayContains.checkNotIndeterminate(result);
                if (!result.booleanValue()) continue;
                return true;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean contains(@TypeParameter(value="T") Type elementType, @OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle equals, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") Slice value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                Boolean result = equals.invokeExact(elementType.getSlice(arrayBlock, i), value);
                ArrayContains.checkNotIndeterminate(result);
                if (!result.booleanValue()) continue;
                return true;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean contains(@TypeParameter(value="T") Type elementType, @OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle equals, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") long value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                Boolean result = equals.invokeExact(elementType.getLong(arrayBlock, i), value);
                ArrayContains.checkNotIndeterminate(result);
                if (!result.booleanValue()) continue;
                return true;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean contains(@TypeParameter(value="T") Type elementType, @OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle equals, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") boolean value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                Boolean result = equals.invokeExact(elementType.getBoolean(arrayBlock, i), value);
                ArrayContains.checkNotIndeterminate(result);
                if (!result.booleanValue()) continue;
                return true;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    @TypeParameter(value="T")
    @SqlType(value="boolean")
    @SqlNullable
    public static Boolean contains(@TypeParameter(value="T") Type elementType, @OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"T", "T"}) MethodHandle equals, @SqlType(value="array(T)") Block arrayBlock, @SqlType(value="T") double value) {
        boolean foundNull = false;
        for (int i = 0; i < arrayBlock.getPositionCount(); ++i) {
            if (arrayBlock.isNull(i)) {
                foundNull = true;
                continue;
            }
            try {
                Boolean result = equals.invokeExact(elementType.getDouble(arrayBlock, i), value);
                ArrayContains.checkNotIndeterminate(result);
                if (!result.booleanValue()) continue;
                return true;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        if (foundNull) {
            return null;
        }
        return false;
    }

    private static void checkNotIndeterminate(Boolean equalsResult) {
        if (equalsResult == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, "contains does not support arrays with elements that are null or contain null");
        }
    }
}

