/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Objects;

public class ArraySubscriptOperator
extends SqlOperator {
    public static final ArraySubscriptOperator ARRAY_SUBSCRIPT = new ArraySubscriptOperator();
    private static final MethodHandle METHOD_HANDLE_BOOLEAN = Reflection.methodHandle(ArraySubscriptOperator.class, "booleanSubscript", Type.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_LONG = Reflection.methodHandle(ArraySubscriptOperator.class, "longSubscript", Type.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_DOUBLE = Reflection.methodHandle(ArraySubscriptOperator.class, "doubleSubscript", Type.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_SLICE = Reflection.methodHandle(ArraySubscriptOperator.class, "sliceSubscript", Type.class, Block.class, Long.TYPE);
    private static final MethodHandle METHOD_HANDLE_OBJECT = Reflection.methodHandle(ArraySubscriptOperator.class, "objectSubscript", Type.class, Block.class, Long.TYPE);

    protected ArraySubscriptOperator() {
        super(OperatorType.SUBSCRIPT, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("E")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"E"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"array(E)"), (Object)TypeSignature.parseTypeSignature((String)"bigint")));
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkArgument((boundVariables.getTypeVariables().size() == 1 ? 1 : 0) != 0, (String)"Expected one type, got %s", boundVariables.getTypeVariables());
        Type elementType = boundVariables.getTypeVariable("E");
        MethodHandle methodHandle = elementType.getJavaType() == Boolean.TYPE ? METHOD_HANDLE_BOOLEAN : (elementType.getJavaType() == Long.TYPE ? METHOD_HANDLE_LONG : (elementType.getJavaType() == Double.TYPE ? METHOD_HANDLE_DOUBLE : (elementType.getJavaType() == Slice.class ? METHOD_HANDLE_SLICE : METHOD_HANDLE_OBJECT)));
        methodHandle = methodHandle.bindTo(elementType);
        Objects.requireNonNull(methodHandle, "methodHandle is null");
        return new ScalarFunctionImplementation(true, (List<ScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL), (Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), methodHandle, this.isDeterministic());
    }

    @UsedByGeneratedCode
    public static Long longSubscript(Type elementType, Block array, long index) {
        ArraySubscriptOperator.checkIndex(array, index);
        int position = Math.toIntExact(index - 1L);
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getLong(array, position);
    }

    @UsedByGeneratedCode
    public static Boolean booleanSubscript(Type elementType, Block array, long index) {
        ArraySubscriptOperator.checkIndex(array, index);
        int position = Math.toIntExact(index - 1L);
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getBoolean(array, position);
    }

    @UsedByGeneratedCode
    public static Double doubleSubscript(Type elementType, Block array, long index) {
        ArraySubscriptOperator.checkIndex(array, index);
        int position = Math.toIntExact(index - 1L);
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getDouble(array, position);
    }

    @UsedByGeneratedCode
    public static Slice sliceSubscript(Type elementType, Block array, long index) {
        ArraySubscriptOperator.checkIndex(array, index);
        int position = Math.toIntExact(index - 1L);
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getSlice(array, position);
    }

    @UsedByGeneratedCode
    public static Object objectSubscript(Type elementType, Block array, long index) {
        ArraySubscriptOperator.checkIndex(array, index);
        int position = Math.toIntExact(index - 1L);
        if (array.isNull(position)) {
            return null;
        }
        return elementType.getObject(array, position);
    }

    public static void checkArrayIndex(long index) {
        if (index == 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "SQL array indices start at 1");
        }
        if (index < 0L) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Array subscript is negative");
        }
    }

    public static void checkIndex(Block array, long index) {
        ArraySubscriptOperator.checkArrayIndex(index);
        if (index > (long)array.getPositionCount()) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Array subscript out of bounds");
        }
    }
}

