/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.operator.scalar.MapGenericEquality;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.IsNull;
import com.facebook.presto.spi.function.OperatorDependency;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.function.ScalarOperator;
import com.facebook.presto.spi.function.SqlType;
import com.facebook.presto.spi.function.TypeParameter;
import com.facebook.presto.spi.function.TypeParameters;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeUtils;
import java.lang.invoke.MethodHandle;

@ScalarOperator(value=OperatorType.IS_DISTINCT_FROM)
public final class MapDistinctFromOperator {
    private MapDistinctFromOperator() {
    }

    @TypeParameters(value={@TypeParameter(value="K"), @TypeParameter(value="V")})
    @SqlType(value="boolean")
    public static boolean isDistinctFrom(@OperatorDependency(operator=OperatorType.EQUAL, returnType="boolean", argumentTypes={"K", "K"}) MethodHandle keyEqualsFunction, @OperatorDependency(operator=OperatorType.HASH_CODE, returnType="bigint", argumentTypes={"K"}) MethodHandle keyHashcodeFunction, @OperatorDependency(operator=OperatorType.IS_DISTINCT_FROM, returnType="boolean", argumentTypes={"V", "V"}) MethodHandle valueDistinctFromFunction, @TypeParameter(value="K") Type keyType, @TypeParameter(value="V") Type valueType, @SqlType(value="map(K,V)") Block leftMapBlock, @IsNull boolean leftMapNull, @SqlType(value="map(K,V)") Block rightMapBlock, @IsNull boolean rightMapNull) {
        if (leftMapNull != rightMapNull) {
            return true;
        }
        if (leftMapNull) {
            return false;
        }
        return MapGenericEquality.genericEqual(keyType, leftMapBlock, rightMapBlock, (leftMapIndex, rightMapIndex) -> {
            boolean rightNull;
            Object leftValue = TypeUtils.readNativeValue((Type)valueType, (Block)leftMapBlock, (int)leftMapIndex);
            Object rightValue = TypeUtils.readNativeValue((Type)valueType, (Block)rightMapBlock, (int)rightMapIndex);
            boolean leftNull = leftValue == null;
            boolean bl = rightNull = rightValue == null;
            if (leftNull || rightNull) {
                return leftNull == rightNull;
            }
            return !valueDistinctFromFunction.invoke(leftValue, leftNull, rightValue, rightNull);
        }) == false;
    }
}

