/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.annotation.UsedByGeneratedCode;
import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.aggregation.TypedSet;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.block.BlockBuilder;
import com.facebook.presto.spi.block.MethodHandleUtil;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeSignatureParameter;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.primitives.Primitives;
import io.airlift.slice.Slice;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.List;

public final class MapToMapCast
extends SqlOperator {
    public static final MapToMapCast MAP_TO_MAP_CAST = new MapToMapCast();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(MapToMapCast.class, "mapCast", MethodHandle.class, MethodHandle.class, Type.class, ConnectorSession.class, Block.class);
    private static final MethodHandle CHECK_LONG_IS_NOT_NULL = Reflection.methodHandle(MapToMapCast.class, "checkLongIsNotNull", Long.class);
    private static final MethodHandle CHECK_DOUBLE_IS_NOT_NULL = Reflection.methodHandle(MapToMapCast.class, "checkDoubleIsNotNull", Double.class);
    private static final MethodHandle CHECK_BOOLEAN_IS_NOT_NULL = Reflection.methodHandle(MapToMapCast.class, "checkBooleanIsNotNull", Boolean.class);
    private static final MethodHandle CHECK_SLICE_IS_NOT_NULL = Reflection.methodHandle(MapToMapCast.class, "checkSliceIsNotNull", Slice.class);
    private static final MethodHandle CHECK_BLOCK_IS_NOT_NULL = Reflection.methodHandle(MapToMapCast.class, "checkBlockIsNotNull", Block.class);

    public MapToMapCast() {
        super(OperatorType.CAST, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.typeVariable("FK"), (Object)Signature.typeVariable("FV"), (Object)Signature.typeVariable("TK"), (Object)Signature.typeVariable("TV")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"map(TK,TV)"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"map(FK,FV)")));
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        Preconditions.checkArgument((arity == 1 ? 1 : 0) != 0, (Object)"Expected arity to be 1");
        Type fromKeyType = boundVariables.getTypeVariable("FK");
        Type fromValueType = boundVariables.getTypeVariable("FV");
        Type toKeyType = boundVariables.getTypeVariable("TK");
        Type toValueType = boundVariables.getTypeVariable("TV");
        Type toMapType = typeManager.getParameterizedType("map", (List)ImmutableList.of((Object)TypeSignatureParameter.of((TypeSignature)toKeyType.getTypeSignature()), (Object)TypeSignatureParameter.of((TypeSignature)toValueType.getTypeSignature())));
        MethodHandle keyProcessor = this.buildProcessor(functionRegistry, fromKeyType, toKeyType, true);
        MethodHandle valueProcessor = this.buildProcessor(functionRegistry, fromValueType, toValueType, false);
        MethodHandle target = MethodHandles.insertArguments(METHOD_HANDLE, 0, keyProcessor, valueProcessor, toMapType);
        return new ScalarFunctionImplementation(true, (List<ScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.RETURN_NULL_ON_NULL)), target, true);
    }

    private MethodHandle buildProcessor(FunctionRegistry functionRegistry, Type fromType, Type toType, boolean isKey) {
        MethodHandle getter = MethodHandleUtil.nativeValueGetter((Type)fromType);
        ScalarFunctionImplementation castImplementation = functionRegistry.getScalarFunctionImplementation(functionRegistry.getCoercion(fromType, toType));
        MethodHandle cast = castImplementation.getMethodHandle();
        if (cast.type().parameterArray()[0] != ConnectorSession.class) {
            cast = MethodHandles.dropArguments(cast, 0, new Class[]{ConnectorSession.class});
        }
        cast = MethodHandles.permuteArguments(cast, MethodType.methodType(cast.type().returnType(), cast.type().parameterArray()[1], new Class[]{cast.type().parameterArray()[0]}), 1, 0);
        MethodHandle target = MethodHandleUtil.compose((MethodHandle)cast, (MethodHandle)getter);
        if (isKey && castImplementation.isNullable()) {
            target = MethodHandleUtil.compose((MethodHandle)this.nullChecker((Class<?>)target.type().returnType()), (MethodHandle)target);
        }
        MethodHandle writer = MethodHandleUtil.nativeValueWriter((Type)toType);
        writer = MethodHandles.permuteArguments(writer, MethodType.methodType(Void.TYPE, writer.type().parameterArray()[1], writer.type().parameterArray()[0]), 1, 0);
        return MethodHandleUtil.compose((MethodHandle)writer, (MethodHandle)target.asType(MethodType.methodType(Primitives.unwrap((Class)target.type().returnType()), target.type().parameterArray())));
    }

    private MethodHandle nullChecker(Class<?> javaType) {
        if (javaType == Long.class) {
            return CHECK_LONG_IS_NOT_NULL;
        }
        if (javaType == Double.class) {
            return CHECK_DOUBLE_IS_NOT_NULL;
        }
        if (javaType == Boolean.class) {
            return CHECK_BOOLEAN_IS_NOT_NULL;
        }
        if (javaType == Slice.class) {
            return CHECK_SLICE_IS_NOT_NULL;
        }
        if (javaType == Block.class) {
            return CHECK_BLOCK_IS_NOT_NULL;
        }
        throw new IllegalArgumentException("Unknown java type " + javaType);
    }

    @UsedByGeneratedCode
    public static long checkLongIsNotNull(Long value) {
        if (value == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "map key is null");
        }
        return value;
    }

    @UsedByGeneratedCode
    public static double checkDoubleIsNotNull(Double value) {
        if (value == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "map key is null");
        }
        return value;
    }

    @UsedByGeneratedCode
    public static boolean checkBooleanIsNotNull(Boolean value) {
        if (value == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "map key is null");
        }
        return value;
    }

    @UsedByGeneratedCode
    public static Slice checkSliceIsNotNull(Slice value) {
        if (value == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "map key is null");
        }
        return value;
    }

    @UsedByGeneratedCode
    public static Block checkBlockIsNotNull(Block value) {
        if (value == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "map key is null");
        }
        return value;
    }

    @UsedByGeneratedCode
    public static Block mapCast(MethodHandle keyProcessFunction, MethodHandle valueProcessFunction, Type toMapType, ConnectorSession session, Block fromMap) {
        Preconditions.checkState((toMapType.getTypeParameters().size() == 2 ? 1 : 0) != 0, (Object)"Expect two type parameters for toMapType");
        Type toKeyType = (Type)toMapType.getTypeParameters().get(0);
        TypedSet typedSet = new TypedSet(toKeyType, fromMap.getPositionCount() / 2, "map-to-map cast");
        BlockBuilder keyBlockBuilder = toKeyType.createBlockBuilder(null, fromMap.getPositionCount() / 2);
        for (int i = 0; i < fromMap.getPositionCount(); i += 2) {
            try {
                keyProcessFunction.invokeExact(fromMap, i, session, keyBlockBuilder);
                continue;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        Block keyBlock = keyBlockBuilder.build();
        BlockBuilder mapBlockBuilder = toMapType.createBlockBuilder(null, 1);
        BlockBuilder blockBuilder = mapBlockBuilder.beginBlockEntry();
        for (int i = 0; i < fromMap.getPositionCount(); i += 2) {
            if (!typedSet.contains(keyBlock, i / 2)) {
                typedSet.add(keyBlock, i / 2);
                toKeyType.appendTo(keyBlock, i / 2, blockBuilder);
                if (fromMap.isNull(i + 1)) {
                    blockBuilder.appendNull();
                    continue;
                }
                try {
                    valueProcessFunction.invokeExact(fromMap, i + 1, session, blockBuilder);
                    continue;
                }
                catch (Throwable t) {
                    throw Failures.internalError(t);
                }
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_CAST_ARGUMENT, "duplicate keys");
        }
        mapBlockBuilder.closeEntry();
        return (Block)toMapType.getObject((Block)mapBlockBuilder, mapBlockBuilder.getPositionCount() - 1);
    }
}

