/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.metadata.BoundVariables;
import com.facebook.presto.metadata.FunctionInvoker;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.LongVariableConstraint;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.SqlOperator;
import com.facebook.presto.metadata.TypeVariableConstraint;
import com.facebook.presto.operator.scalar.ScalarFunctionImplementation;
import com.facebook.presto.spi.InvocationConvention;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.function.OperatorType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.spi.type.TypeUtils;
import com.facebook.presto.util.Failures;
import com.facebook.presto.util.Reflection;
import com.google.common.base.Defaults;
import com.google.common.collect.ImmutableList;
import java.lang.invoke.MethodHandle;
import java.util.List;
import java.util.Optional;

public class RowDistinctFromOperator
extends SqlOperator {
    public static final RowDistinctFromOperator ROW_DISTINCT_FROM = new RowDistinctFromOperator();
    private static final MethodHandle METHOD_HANDLE = Reflection.methodHandle(RowDistinctFromOperator.class, "isDistinctFrom", Type.class, List.class, Block.class, Boolean.TYPE, Block.class, Boolean.TYPE);

    private RowDistinctFromOperator() {
        super(OperatorType.IS_DISTINCT_FROM, (List<TypeVariableConstraint>)ImmutableList.of((Object)Signature.comparableWithVariadicBound("T", "row")), (List<LongVariableConstraint>)ImmutableList.of(), TypeSignature.parseTypeSignature((String)"boolean"), (List<TypeSignature>)ImmutableList.of((Object)TypeSignature.parseTypeSignature((String)"T"), (Object)TypeSignature.parseTypeSignature((String)"T")));
    }

    @Override
    public ScalarFunctionImplementation specialize(BoundVariables boundVariables, int arity, TypeManager typeManager, FunctionRegistry functionRegistry) {
        ImmutableList.Builder argumentMethods = ImmutableList.builder();
        Type type = boundVariables.getTypeVariable("T");
        for (Type parameterType : type.getTypeParameters()) {
            Signature signature = functionRegistry.resolveOperator(OperatorType.IS_DISTINCT_FROM, (List<? extends Type>)ImmutableList.of((Object)parameterType, (Object)parameterType));
            FunctionInvoker functionInvoker = functionRegistry.getFunctionInvokerProvider().createFunctionInvoker(signature, Optional.of(new InvocationConvention((List)ImmutableList.of((Object)InvocationConvention.InvocationArgumentConvention.NULL_FLAG, (Object)InvocationConvention.InvocationArgumentConvention.NULL_FLAG), InvocationConvention.InvocationReturnConvention.FAIL_ON_NULL, false)));
            argumentMethods.add((Object)functionInvoker.methodHandle());
        }
        return new ScalarFunctionImplementation(false, (List<ScalarFunctionImplementation.ArgumentProperty>)ImmutableList.of((Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.USE_NULL_FLAG), (Object)ScalarFunctionImplementation.ArgumentProperty.valueTypeArgumentProperty(ScalarFunctionImplementation.NullConvention.USE_NULL_FLAG)), METHOD_HANDLE.bindTo(type).bindTo(argumentMethods.build()), this.isDeterministic());
    }

    public static boolean isDistinctFrom(Type rowType, List<MethodHandle> argumentMethods, Block leftRow, boolean leftNull, Block rightRow, boolean rightNull) {
        if (leftNull != rightNull) {
            return true;
        }
        if (leftNull) {
            return false;
        }
        List fieldTypes = rowType.getTypeParameters();
        for (int i = 0; i < leftRow.getPositionCount(); ++i) {
            Object rightValue;
            boolean rightValueNull;
            boolean leftValueNull;
            Type type = (Type)fieldTypes.get(i);
            Object leftValue = TypeUtils.readNativeValue((Type)type, (Block)leftRow, (int)i);
            boolean bl = leftValueNull = leftValue == null;
            if (leftValueNull) {
                leftValue = Defaults.defaultValue((Class)type.getJavaType());
            }
            boolean bl2 = rightValueNull = (rightValue = TypeUtils.readNativeValue((Type)type, (Block)rightRow, (int)i)) == null;
            if (rightValueNull) {
                rightValue = Defaults.defaultValue((Class)type.getJavaType());
            }
            try {
                if (!argumentMethods.get(i).invoke(leftValue, leftValueNull, rightValue, rightValueNull)) continue;
                return true;
            }
            catch (Throwable t) {
                throw Failures.internalError(t);
            }
        }
        return false;
    }
}

