/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.scalar;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.function.Description;
import com.facebook.presto.spi.function.ScalarFunction;
import com.facebook.presto.spi.function.SqlType;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;

public final class SessionFunctions {
    private SessionFunctions() {
    }

    @ScalarFunction(value="$current_user", hidden=true)
    @Description(value="current user")
    @SqlType(value="varchar")
    public static Slice currentUser(ConnectorSession session) {
        return Slices.utf8Slice((String)session.getUser());
    }

    @ScalarFunction(value="$current_path", hidden=true)
    @Description(value="retrieve current path")
    @SqlType(value="varchar")
    public static Slice currentPath(ConnectorSession session) {
        if (session.getPath() == null) {
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.INVALID_FUNCTION_ARGUMENT, "Session path is null");
        }
        return Slices.utf8Slice((String)session.getPath());
    }
}

