/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.operator.window;

import com.facebook.presto.metadata.Signature;
import com.facebook.presto.operator.window.WindowFunctionSupplier;
import com.facebook.presto.spi.function.WindowFunction;
import com.google.common.base.Preconditions;
import java.util.List;
import java.util.Objects;

public abstract class AbstractWindowFunctionSupplier
implements WindowFunctionSupplier {
    private final Signature signature;
    private final String description;

    protected AbstractWindowFunctionSupplier(Signature signature, String description) {
        this.signature = Objects.requireNonNull(signature, "signature is null");
        this.description = description;
    }

    @Override
    public final Signature getSignature() {
        return this.signature;
    }

    @Override
    public final String getDescription() {
        return this.description;
    }

    @Override
    public final WindowFunction createWindowFunction(List<Integer> argumentChannels) {
        Objects.requireNonNull(argumentChannels, "inputs is null");
        Preconditions.checkArgument((argumentChannels.size() == this.signature.getArgumentTypes().size() ? 1 : 0) != 0, (String)"Expected %s arguments for function %s, but got %s", (Object)this.signature.getArgumentTypes().size(), (Object)this.signature.getName(), (Object)argumentChannels.size());
        return this.newWindowFunction(argumentChannels);
    }

    protected abstract WindowFunction newWindowFunction(List<Integer> var1);
}

