/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.security;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class PrincipalUserMatchRule {
    private final Pattern principalRegex;
    private final Optional<Pattern> userRegex;
    private final Optional<String> principalToUserSubstitution;
    private final boolean allow;

    @JsonCreator
    public PrincipalUserMatchRule(@JsonProperty(value="principal") Pattern principalRegex, @JsonProperty(value="user") Optional<Pattern> userRegex, @JsonProperty(value="principal_to_user") Optional<String> principalToUserSubstitution, @JsonProperty(value="allow") boolean allow) {
        this.principalRegex = Objects.requireNonNull(principalRegex, "principalRegex is null");
        this.userRegex = Objects.requireNonNull(userRegex, "userRegex is null");
        this.principalToUserSubstitution = Objects.requireNonNull(principalToUserSubstitution, "principalToUserSubstitution is null");
        Preconditions.checkState((userRegex.isPresent() || principalToUserSubstitution.isPresent() ? 1 : 0) != 0, (Object)"A valid principal rule must provide at least one criterion of user and user_extraction");
        this.allow = allow;
    }

    public Optional<Boolean> match(String principal, String user) {
        String userExtraction;
        Matcher matcher = this.principalRegex.matcher(principal);
        if (!matcher.matches()) {
            return Optional.empty();
        }
        if (this.userRegex.isPresent() && this.userRegex.get().matcher(user).matches()) {
            return Optional.of(this.allow);
        }
        if (this.principalToUserSubstitution.isPresent() && user.equals(userExtraction = matcher.replaceAll(this.principalToUserSubstitution.get()))) {
            return Optional.of(this.allow);
        }
        return Optional.empty();
    }
}

