/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.server.protocol;

import com.facebook.presto.execution.QueryManager;
import com.facebook.presto.execution.QueryState;
import com.facebook.presto.server.protocol.Query;
import com.facebook.presto.spi.QueryId;
import com.google.common.collect.ImmutableSet;
import io.airlift.log.Logger;
import java.util.Optional;
import java.util.concurrent.ConcurrentMap;

class PurgeQueriesRunnable
implements Runnable {
    private static final Logger log = Logger.get(PurgeQueriesRunnable.class);
    private final ConcurrentMap<QueryId, Query> queries;
    private final QueryManager queryManager;

    public PurgeQueriesRunnable(ConcurrentMap<QueryId, Query> queries, QueryManager queryManager) {
        this.queries = queries;
        this.queryManager = queryManager;
    }

    @Override
    public void run() {
        try {
            for (QueryId queryId : ImmutableSet.copyOf(this.queries.keySet())) {
                Query query = (Query)this.queries.get(queryId);
                if (!query.isSubmissionFinished()) continue;
                Optional<QueryState> state = this.queryManager.getQueryState(queryId);
                if (!state.isPresent() || state.get() == QueryState.FAILED) {
                    query.dispose();
                }
                if (state.isPresent()) continue;
                this.queries.remove(queryId);
            }
        }
        catch (Throwable e) {
            log.warn(e, "Error removing old queries");
        }
    }
}

