/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.spiller;

import com.facebook.presto.memory.context.AggregatedMemoryContext;
import com.facebook.presto.operator.SpillContext;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spiller.SingleStreamSpiller;
import com.facebook.presto.spiller.SingleStreamSpillerFactory;
import com.facebook.presto.spiller.Spiller;
import com.google.common.base.Preconditions;
import com.google.common.io.Closer;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.concurrent.NotThreadSafe;

@NotThreadSafe
public class GenericSpiller
implements Spiller {
    private final List<Type> types;
    private final SpillContext spillContext;
    private final AggregatedMemoryContext aggregatedMemoryContext;
    private final SingleStreamSpillerFactory singleStreamSpillerFactory;
    private final Closer closer = Closer.create();
    private ListenableFuture<?> previousSpill = Futures.immediateFuture(null);
    private final List<SingleStreamSpiller> singleStreamSpillers = new ArrayList<SingleStreamSpiller>();

    public GenericSpiller(List<Type> types, SpillContext spillContext, AggregatedMemoryContext aggregatedMemoryContext, SingleStreamSpillerFactory singleStreamSpillerFactory) {
        this.types = Objects.requireNonNull(types, "types can not be null");
        this.spillContext = Objects.requireNonNull(spillContext, "spillContext can not be null");
        this.aggregatedMemoryContext = Objects.requireNonNull(aggregatedMemoryContext, "aggregatedMemoryContext can not be null");
        this.singleStreamSpillerFactory = Objects.requireNonNull(singleStreamSpillerFactory, "singleStreamSpillerFactory can not be null");
    }

    @Override
    public ListenableFuture<?> spill(Iterator<Page> pageIterator) {
        this.checkNoSpillInProgress();
        SingleStreamSpiller singleStreamSpiller = this.singleStreamSpillerFactory.create(this.types, this.spillContext, this.aggregatedMemoryContext.newLocalMemoryContext(GenericSpiller.class.getSimpleName()));
        this.closer.register((Closeable)singleStreamSpiller);
        this.singleStreamSpillers.add(singleStreamSpiller);
        this.previousSpill = singleStreamSpiller.spill(pageIterator);
        return this.previousSpill;
    }

    @Override
    public List<Iterator<Page>> getSpills() {
        this.checkNoSpillInProgress();
        return this.singleStreamSpillers.stream().map(SingleStreamSpiller::getSpilledPages).collect(Collectors.toList());
    }

    @Override
    public void close() {
        try {
            this.closer.close();
        }
        catch (IOException e) {
            throw new RuntimeException("could not close some single stream spillers", e);
        }
    }

    private void checkNoSpillInProgress() {
        Preconditions.checkState((boolean)this.previousSpill.isDone(), (Object)"previous spill still in progress");
    }
}

