/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.split;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.execution.Lifespan;
import com.facebook.presto.metadata.Split;
import com.facebook.presto.spi.connector.ConnectorPartitionHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.google.common.util.concurrent.ListenableFuture;
import java.io.Closeable;
import java.util.List;
import java.util.Objects;

public interface SplitSource
extends Closeable {
    public ConnectorId getConnectorId();

    public ConnectorTransactionHandle getTransactionHandle();

    public ListenableFuture<SplitBatch> getNextBatch(ConnectorPartitionHandle var1, Lifespan var2, int var3);

    @Override
    public void close();

    public boolean isFinished();

    public static class SplitBatch {
        private final List<Split> splits;
        private final boolean lastBatch;

        public SplitBatch(List<Split> splits, boolean lastBatch) {
            this.splits = Objects.requireNonNull(splits, "splits is null");
            this.lastBatch = lastBatch;
        }

        public List<Split> getSplits() {
            return this.splits;
        }

        public boolean isLastBatch() {
            return this.lastBatch;
        }
    }
}

