/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql;

import com.facebook.presto.sql.tree.Identifier;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Objects;
import java.util.Optional;

public final class SqlPathElement {
    private final Optional<Identifier> catalog;
    private final Identifier schema;

    @JsonCreator
    public SqlPathElement(@JsonProperty(value="catalog") Optional<Identifier> catalog, @JsonProperty(value="schema") Identifier schema) {
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
    }

    @JsonProperty
    public Optional<Identifier> getCatalog() {
        return this.catalog;
    }

    @JsonProperty
    public Identifier getSchema() {
        return this.schema;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        SqlPathElement that = (SqlPathElement)obj;
        return Objects.equals(this.catalog, that.catalog) && Objects.equals(this.schema, that.schema);
    }

    public int hashCode() {
        return Objects.hash(this.catalog, this.schema);
    }

    public String toString() {
        if (this.catalog.isPresent()) {
            return String.format("%s.%s", this.catalog.get().toString(), this.schema.toString());
        }
        return this.schema.toString();
    }
}

