/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.Session;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.QualifiedObjectName;
import com.facebook.presto.security.AccessControl;
import com.facebook.presto.sql.analyzer.Analysis;
import com.facebook.presto.sql.analyzer.ExpressionTreeUtils;
import com.facebook.presto.sql.analyzer.QueryExplainer;
import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.analyzer.SemanticException;
import com.facebook.presto.sql.analyzer.StatementAnalyzer;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.rewrite.StatementRewrite;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.GroupingOperation;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class Analyzer {
    private final Metadata metadata;
    private final SqlParser sqlParser;
    private final AccessControl accessControl;
    private final Session session;
    private final Optional<QueryExplainer> queryExplainer;
    private final List<Expression> parameters;

    public Analyzer(Session session, Metadata metadata, SqlParser sqlParser, AccessControl accessControl, Optional<QueryExplainer> queryExplainer, List<Expression> parameters) {
        this.session = Objects.requireNonNull(session, "session is null");
        this.metadata = Objects.requireNonNull(metadata, "metadata is null");
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.accessControl = Objects.requireNonNull(accessControl, "accessControl is null");
        this.queryExplainer = Objects.requireNonNull(queryExplainer, "query explainer is null");
        this.parameters = parameters;
    }

    public Analysis analyze(Statement statement) {
        return this.analyze(statement, false);
    }

    public Analysis analyze(Statement statement, boolean isDescribe) {
        Statement rewrittenStatement = StatementRewrite.rewrite(this.session, this.metadata, this.sqlParser, this.queryExplainer, statement, this.parameters, this.accessControl);
        Analysis analysis = new Analysis(rewrittenStatement, this.parameters, isDescribe);
        StatementAnalyzer analyzer = new StatementAnalyzer(analysis, this.metadata, this.sqlParser, this.accessControl, this.session);
        analyzer.analyze((Node)rewrittenStatement, Optional.empty());
        analysis.getTableColumnReferences().forEach((accessControlInfo, tableColumnReferences) -> tableColumnReferences.forEach((tableName, columns) -> accessControlInfo.getAccessControl().checkCanSelectFromColumns(this.session.getRequiredTransactionId(), accessControlInfo.getIdentity(), (QualifiedObjectName)tableName, (Set<String>)columns)));
        return analysis;
    }

    static void verifyNoAggregateWindowOrGroupingFunctions(FunctionRegistry functionRegistry, Expression predicate, String clause) {
        List<GroupingOperation> groupingOperations;
        List<FunctionCall> windowExpressions;
        List<FunctionCall> aggregates = ExpressionTreeUtils.extractAggregateFunctions((Iterable<? extends Node>)ImmutableList.of((Object)predicate), functionRegistry);
        ImmutableList found = ImmutableList.copyOf((Iterable)Iterables.concat(aggregates, windowExpressions = ExpressionTreeUtils.extractWindowFunctions((Iterable<? extends Node>)ImmutableList.of((Object)predicate)), groupingOperations = ExpressionTreeUtils.extractExpressions((Iterable<? extends Node>)ImmutableList.of((Object)predicate), GroupingOperation.class)));
        if (!found.isEmpty()) {
            throw new SemanticException(SemanticErrorCode.CANNOT_HAVE_AGGREGATIONS_WINDOWS_OR_GROUPING, (Node)predicate, "%s cannot contain aggregations, window functions or grouping operations: %s", clause, found);
        }
    }
}

