/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.analyzer;

import com.facebook.presto.sql.analyzer.SemanticErrorCode;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.NodeLocation;
import java.util.Objects;

public class SemanticException
extends RuntimeException {
    private final SemanticErrorCode code;
    private final Node node;

    public SemanticException(SemanticErrorCode code, Node node, String format, Object ... args) {
        super(SemanticException.formatMessage(format, node, args));
        Objects.requireNonNull(code, "code is null");
        Objects.requireNonNull(node, "node is null");
        this.code = code;
        this.node = node;
    }

    public Node getNode() {
        return this.node;
    }

    public SemanticErrorCode getCode() {
        return this.code;
    }

    private static String formatMessage(String formatString, Node node, Object[] args) {
        if (node.getLocation().isPresent()) {
            NodeLocation nodeLocation = (NodeLocation)node.getLocation().get();
            return String.format("line %s:%s: %s", nodeLocation.getLineNumber(), nodeLocation.getColumnNumber(), String.format(formatString, args));
        }
        return String.format(formatString, args);
    }
}

