/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.gen;

import com.facebook.presto.metadata.Signature;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.gen.BytecodeGenerator;
import com.facebook.presto.sql.gen.BytecodeGeneratorContext;
import com.facebook.presto.sql.relational.RowExpression;
import com.google.common.collect.Lists;
import io.airlift.bytecode.BytecodeBlock;
import io.airlift.bytecode.BytecodeNode;
import io.airlift.bytecode.Variable;
import io.airlift.bytecode.control.IfStatement;
import io.airlift.bytecode.expression.BytecodeExpressions;
import java.util.ArrayList;
import java.util.List;

public class CoalesceCodeGenerator
implements BytecodeGenerator {
    @Override
    public BytecodeNode generateExpression(Signature signature, BytecodeGeneratorContext generatorContext, Type returnType, List<RowExpression> arguments) {
        ArrayList<BytecodeNode> operands = new ArrayList<BytecodeNode>();
        for (RowExpression expression : arguments) {
            operands.add(generatorContext.generate(expression));
        }
        Variable wasNull = generatorContext.wasNull();
        BytecodeBlock nullValue = new BytecodeBlock().append((BytecodeNode)wasNull.set(BytecodeExpressions.constantTrue())).pushJavaDefault(returnType.getJavaType());
        for (BytecodeNode operand : Lists.reverse(operands)) {
            IfStatement ifStatement = new IfStatement();
            ifStatement.condition().append(operand).append((BytecodeNode)wasNull);
            ifStatement.ifTrue().pop(returnType.getJavaType()).append((BytecodeNode)wasNull.set(BytecodeExpressions.constantFalse())).append((BytecodeNode)nullValue);
            nullValue = ifStatement;
        }
        return nullValue;
    }
}

