/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.Session;
import com.facebook.presto.execution.Column;
import com.facebook.presto.execution.Input;
import com.facebook.presto.metadata.Metadata;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayoutHandle;
import com.facebook.presto.metadata.TableMetadata;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;

public class InputExtractor {
    private final Metadata metadata;
    private final Session session;

    public InputExtractor(Metadata metadata, Session session) {
        this.metadata = metadata;
        this.session = session;
    }

    public List<Input> extractInputs(PlanNode root) {
        Visitor visitor = new Visitor();
        root.accept(visitor, null);
        return ImmutableList.copyOf(visitor.getInputs());
    }

    private static Column createColumn(ColumnMetadata columnMetadata) {
        return new Column(columnMetadata.getName(), columnMetadata.getType().toString());
    }

    private Input createInput(TableMetadata table, Optional<TableLayoutHandle> layout, Set<Column> columns) {
        SchemaTableName schemaTable = table.getTable();
        Optional<Object> inputMetadata = layout.flatMap(tableLayout -> this.metadata.getInfo(this.session, (TableLayoutHandle)tableLayout));
        return new Input(table.getConnectorId(), schemaTable.getSchemaName(), schemaTable.getTableName(), inputMetadata, (List<Column>)ImmutableList.copyOf(columns));
    }

    private class Visitor
    extends PlanVisitor<Void, Void> {
        private final ImmutableSet.Builder<Input> inputs = ImmutableSet.builder();

        private Visitor() {
        }

        public Set<Input> getInputs() {
            return this.inputs.build();
        }

        @Override
        public Void visitTableScan(TableScanNode node, Void context) {
            TableHandle tableHandle = node.getTable();
            HashSet<Column> columns = new HashSet<Column>();
            for (ColumnHandle columnHandle : node.getAssignments().values()) {
                columns.add(InputExtractor.createColumn(InputExtractor.this.metadata.getColumnMetadata(InputExtractor.this.session, tableHandle, columnHandle)));
            }
            this.inputs.add((Object)InputExtractor.this.createInput(InputExtractor.this.metadata.getTableMetadata(InputExtractor.this.session, tableHandle), node.getLayout(), columns));
            return null;
        }

        @Override
        public Void visitIndexSource(IndexSourceNode node, Void context) {
            TableHandle tableHandle = node.getTableHandle();
            HashSet<Column> columns = new HashSet<Column>();
            for (ColumnHandle columnHandle : node.getAssignments().values()) {
                columns.add(InputExtractor.createColumn(InputExtractor.this.metadata.getColumnMetadata(InputExtractor.this.session, tableHandle, columnHandle)));
            }
            this.inputs.add((Object)InputExtractor.this.createInput(InputExtractor.this.metadata.getTableMetadata(InputExtractor.this.session, tableHandle), node.getLayout(), columns));
            return null;
        }

        @Override
        protected Void visitPlan(PlanNode node, Void context) {
            for (PlanNode child : node.getSources()) {
                child.accept(this, context);
            }
            return null;
        }
    }
}

