/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.ExpressionRewriter;
import com.facebook.presto.sql.tree.ExpressionTreeRewriter;
import com.facebook.presto.sql.tree.FieldReference;
import com.facebook.presto.sql.tree.LambdaExpression;
import com.facebook.presto.sql.tree.SymbolReference;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class SymbolToInputRewriter {
    private final Map<Symbol, Integer> symbolToChannelMapping;

    public SymbolToInputRewriter(Map<Symbol, Integer> symbolToChannelMapping) {
        Objects.requireNonNull(symbolToChannelMapping, "symbolToChannelMapping is null");
        this.symbolToChannelMapping = ImmutableMap.copyOf(symbolToChannelMapping);
    }

    public Expression rewrite(Expression expression) {
        return ExpressionTreeRewriter.rewriteWith((ExpressionRewriter)new ExpressionRewriter<Context>(){

            public Expression rewriteSymbolReference(SymbolReference node, Context context, ExpressionTreeRewriter<Context> treeRewriter) {
                Integer channel = (Integer)SymbolToInputRewriter.this.symbolToChannelMapping.get(Symbol.from((Expression)node));
                if (channel == null) {
                    Preconditions.checkArgument((boolean)context.isInLambda(), (String)"Cannot resolve symbol %s", (Object)node.getName());
                    return node;
                }
                return new FieldReference(channel.intValue());
            }

            public Expression rewriteLambdaExpression(LambdaExpression node, Context context, ExpressionTreeRewriter<Context> treeRewriter) {
                return treeRewriter.defaultRewrite((Expression)node, (Object)new Context(true));
            }
        }, (Expression)expression, (Object)new Context(false));
    }

    private static class Context {
        private final boolean inLambda;

        public Context(boolean inLambda) {
            this.inLambda = inLambda;
        }

        public boolean isInLambda() {
            return this.inLambda;
        }
    }
}

