/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.iterative.rule;

import com.facebook.presto.matching.Captures;
import com.facebook.presto.matching.Pattern;
import com.facebook.presto.sql.planner.SymbolsExtractor;
import com.facebook.presto.sql.planner.iterative.Rule;
import com.facebook.presto.sql.planner.iterative.rule.Util;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.Patterns;
import com.google.common.base.Predicates;
import com.google.common.collect.ImmutableSet;
import java.util.Set;
import java.util.function.Predicate;

public class PruneJoinChildrenColumns
implements Rule<JoinNode> {
    private static final Pattern<JoinNode> PATTERN = Patterns.join().matching((Predicate)Predicates.not(JoinNode::isCrossJoin));

    @Override
    public Pattern<JoinNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(JoinNode joinNode, Captures captures, Rule.Context context) {
        ImmutableSet globallyUsableInputs = ImmutableSet.builder().addAll(joinNode.getOutputSymbols()).addAll((Iterable)joinNode.getFilter().map(SymbolsExtractor::extractUnique).orElse((Set)ImmutableSet.of())).build();
        ImmutableSet leftUsableInputs = ImmutableSet.builder().addAll((Iterable)globallyUsableInputs).addAll(joinNode.getCriteria().stream().map(JoinNode.EquiJoinClause::getLeft).iterator()).addAll((Iterable)joinNode.getLeftHashSymbol().map(ImmutableSet::of).orElse(ImmutableSet.of())).build();
        ImmutableSet rightUsableInputs = ImmutableSet.builder().addAll((Iterable)globallyUsableInputs).addAll(joinNode.getCriteria().stream().map(JoinNode.EquiJoinClause::getRight).iterator()).addAll((Iterable)joinNode.getRightHashSymbol().map(ImmutableSet::of).orElse(ImmutableSet.of())).build();
        return Util.restrictChildOutputs(context.getIdAllocator(), joinNode, new Set[]{leftUsableInputs, rightUsableInputs}).map(Rule.Result::ofPlanNode).orElse(Rule.Result.empty());
    }
}

