/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.sql.planner.OptimizerStatsRecorder;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.PlanNode;
import java.util.Objects;

public final class StatsRecordingPlanOptimizer
implements PlanOptimizer {
    private final OptimizerStatsRecorder stats;
    private final PlanOptimizer delegate;

    public StatsRecordingPlanOptimizer(OptimizerStatsRecorder stats, PlanOptimizer delegate) {
        this.stats = Objects.requireNonNull(stats, "stats is null");
        this.delegate = Objects.requireNonNull(delegate, "delegate is null");
        stats.register(delegate);
    }

    @Override
    public final PlanNode optimize(PlanNode plan, Session session, TypeProvider types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        long duration;
        PlanNode result;
        try {
            long start = System.nanoTime();
            result = this.delegate.optimize(plan, session, types, symbolAllocator, idAllocator);
            duration = System.nanoTime() - start;
        }
        catch (RuntimeException e) {
            this.stats.recordFailure(this.delegate);
            throw e;
        }
        this.stats.record(this.delegate, duration);
        return result;
    }
}

