/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.optimizations;

import com.facebook.presto.Session;
import com.facebook.presto.sql.planner.PlanNodeIdAllocator;
import com.facebook.presto.sql.planner.SymbolAllocator;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.optimizations.PlanNodeSearcher;
import com.facebook.presto.sql.planner.optimizations.PlanOptimizer;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.SimplePlanRewriter;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import java.util.List;
import java.util.Objects;

@Deprecated
public class TransformCorrelatedSingleRowSubqueryToProject
implements PlanOptimizer {
    @Override
    public PlanNode optimize(PlanNode plan, Session session, TypeProvider types, SymbolAllocator symbolAllocator, PlanNodeIdAllocator idAllocator) {
        return SimplePlanRewriter.rewriteWith(new Rewriter(idAllocator), plan, null);
    }

    private static class Rewriter
    extends SimplePlanRewriter<PlanNode> {
        private final PlanNodeIdAllocator idAllocator;

        public Rewriter(PlanNodeIdAllocator idAllocator) {
            this.idAllocator = Objects.requireNonNull(idAllocator, "idAllocator is null");
        }

        @Override
        public PlanNode visitLateralJoin(LateralJoinNode lateral, SimplePlanRewriter.RewriteContext<PlanNode> context) {
            LateralJoinNode rewrittenLateral = (LateralJoinNode)context.defaultRewrite(lateral, context.get());
            if (rewrittenLateral.getCorrelation().isEmpty()) {
                return rewrittenLateral;
            }
            List values = PlanNodeSearcher.searchFrom(lateral.getSubquery()).recurseOnlyWhen(ProjectNode.class::isInstance).where(ValuesNode.class::isInstance).findAll();
            if (values.size() != 1 || !Rewriter.isSingleRowValuesWithNoColumns((ValuesNode)values.get(0))) {
                return rewrittenLateral;
            }
            List subqueryProjections = PlanNodeSearcher.searchFrom(rewrittenLateral.getSubquery()).where(node -> node instanceof ProjectNode && !node.getOutputSymbols().equals(rewrittenLateral.getCorrelation())).findAll();
            if (subqueryProjections.size() == 0) {
                return rewrittenLateral.getInput();
            }
            if (subqueryProjections.size() == 1) {
                Assignments assignments = Assignments.builder().putIdentities(rewrittenLateral.getInput().getOutputSymbols()).putAll(((ProjectNode)subqueryProjections.get(0)).getAssignments()).build();
                return this.projectNode(rewrittenLateral.getInput(), assignments);
            }
            return rewrittenLateral;
        }

        private ProjectNode projectNode(PlanNode source, Assignments assignments) {
            return new ProjectNode(this.idAllocator.getNextId(), source, assignments);
        }

        private static boolean isSingleRowValuesWithNoColumns(ValuesNode values) {
            return values.getRows().size() == 1 && values.getRows().get(0).size() == 0;
        }
    }
}

