/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.tree.Node;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import javax.annotation.concurrent.Immutable;

@Immutable
public class LateralJoinNode
extends PlanNode {
    private final PlanNode input;
    private final PlanNode subquery;
    private final List<Symbol> correlation;
    private final Type type;
    private final Node originSubquery;

    @JsonCreator
    public LateralJoinNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="input") PlanNode input, @JsonProperty(value="subquery") PlanNode subquery, @JsonProperty(value="correlation") List<Symbol> correlation, @JsonProperty(value="type") Type type, @JsonProperty(value="originSubquery") Node originSubquery) {
        super(id);
        Objects.requireNonNull(input, "input is null");
        Objects.requireNonNull(subquery, "right is null");
        Objects.requireNonNull(correlation, "correlation is null");
        Objects.requireNonNull(originSubquery, "originSubquery is null");
        Preconditions.checkArgument((boolean)input.getOutputSymbols().containsAll(correlation), (Object)"Input does not contain symbols from correlation");
        this.input = input;
        this.subquery = subquery;
        this.correlation = ImmutableList.copyOf(correlation);
        this.type = type;
        this.originSubquery = originSubquery;
    }

    @JsonProperty(value="input")
    public PlanNode getInput() {
        return this.input;
    }

    @JsonProperty(value="subquery")
    public PlanNode getSubquery() {
        return this.subquery;
    }

    @JsonProperty(value="correlation")
    public List<Symbol> getCorrelation() {
        return this.correlation;
    }

    @JsonProperty(value="type")
    public Type getType() {
        return this.type;
    }

    @JsonProperty(value="originSubquery")
    public Node getOriginSubquery() {
        return this.originSubquery;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of((Object)this.input, (Object)this.subquery);
    }

    @Override
    @JsonProperty(value="outputSymbols")
    public List<Symbol> getOutputSymbols() {
        return ImmutableList.builder().addAll(this.input.getOutputSymbols()).addAll(this.subquery.getOutputSymbols()).build();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((newChildren.size() == 2 ? 1 : 0) != 0, (Object)"expected newChildren to contain 2 nodes");
        return new LateralJoinNode(this.getId(), newChildren.get(0), newChildren.get(1), this.correlation, this.type, this.originSubquery);
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitLateralJoin(this, context);
    }

    public static enum Type {
        INNER(JoinNode.Type.INNER),
        LEFT(JoinNode.Type.LEFT);

        private final JoinNode.Type joinNodeType;

        private Type(JoinNode.Type joinNodeType) {
            this.joinNodeType = joinNodeType;
        }

        public JoinNode.Type toJoinNodeType() {
            return this.joinNodeType;
        }
    }
}

