/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.plan;

import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.metadata.TableLayoutHandle;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

@Immutable
public class TableScanNode
extends PlanNode {
    private final TableHandle table;
    private final Optional<TableLayoutHandle> tableLayout;
    private final List<Symbol> outputSymbols;
    private final Map<Symbol, ColumnHandle> assignments;
    private final TupleDomain<ColumnHandle> currentConstraint;

    @JsonCreator
    public TableScanNode(@JsonProperty(value="id") PlanNodeId id, @JsonProperty(value="table") TableHandle table, @JsonProperty(value="outputSymbols") List<Symbol> outputs, @JsonProperty(value="assignments") Map<Symbol, ColumnHandle> assignments, @JsonProperty(value="layout") Optional<TableLayoutHandle> tableLayout) {
        this(id, table, outputs, assignments, tableLayout, null);
    }

    public TableScanNode(PlanNodeId id, TableHandle table, List<Symbol> outputs, Map<Symbol, ColumnHandle> assignments, Optional<TableLayoutHandle> tableLayout, @Nullable TupleDomain<ColumnHandle> currentConstraint) {
        super(id);
        Objects.requireNonNull(table, "table is null");
        Objects.requireNonNull(outputs, "outputs is null");
        Objects.requireNonNull(assignments, "assignments is null");
        Preconditions.checkArgument((boolean)assignments.keySet().containsAll(outputs), (Object)"assignments does not cover all of outputs");
        Objects.requireNonNull(tableLayout, "tableLayout is null");
        if (currentConstraint != null) {
            Preconditions.checkArgument((currentConstraint.isAll() || tableLayout.isPresent() ? 1 : 0) != 0, (Object)"currentConstraint present without layout");
        }
        this.table = table;
        this.outputSymbols = ImmutableList.copyOf(outputs);
        this.assignments = ImmutableMap.copyOf(assignments);
        this.tableLayout = tableLayout;
        this.currentConstraint = currentConstraint;
    }

    @JsonProperty(value="table")
    public TableHandle getTable() {
        return this.table;
    }

    @JsonProperty
    public Optional<TableLayoutHandle> getLayout() {
        return this.tableLayout;
    }

    @Override
    @JsonProperty(value="outputSymbols")
    public List<Symbol> getOutputSymbols() {
        return this.outputSymbols;
    }

    @JsonProperty(value="assignments")
    public Map<Symbol, ColumnHandle> getAssignments() {
        return this.assignments;
    }

    public TupleDomain<ColumnHandle> getCurrentConstraint() {
        Preconditions.checkState((this.currentConstraint != null ? 1 : 0) != 0, (Object)"currentConstraint should only be used in planner. It is not transported to workers.");
        return this.currentConstraint;
    }

    @Override
    public List<PlanNode> getSources() {
        return ImmutableList.of();
    }

    @Override
    public <R, C> R accept(PlanVisitor<R, C> visitor, C context) {
        return visitor.visitTableScan(this, context);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("table", (Object)this.table).add("tableLayout", this.tableLayout).add("outputSymbols", this.outputSymbols).add("assignments", this.assignments).add("currentConstraint", this.currentConstraint).toString();
    }

    @Override
    public PlanNode replaceChildren(List<PlanNode> newChildren) {
        Preconditions.checkArgument((boolean)newChildren.isEmpty(), (Object)"newChildren is not empty");
        return this;
    }
}

