/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.sql.planner.planPrinter;

import com.facebook.presto.Session;
import com.facebook.presto.SystemSessionProperties;
import com.facebook.presto.cost.CachingCostProvider;
import com.facebook.presto.cost.CachingStatsProvider;
import com.facebook.presto.cost.CostCalculator;
import com.facebook.presto.cost.CostProvider;
import com.facebook.presto.cost.FragmentedPlanCostCalculator;
import com.facebook.presto.cost.FragmentedPlanSourceProvider;
import com.facebook.presto.cost.FragmentedPlanStatsCalculator;
import com.facebook.presto.cost.PlanNodeCostEstimate;
import com.facebook.presto.cost.PlanNodeSourceProvider;
import com.facebook.presto.cost.PlanNodeStatsEstimate;
import com.facebook.presto.cost.StatsCalculator;
import com.facebook.presto.cost.StatsProvider;
import com.facebook.presto.execution.StageInfo;
import com.facebook.presto.execution.StageStats;
import com.facebook.presto.execution.scheduler.NodeSchedulerConfig;
import com.facebook.presto.metadata.FunctionRegistry;
import com.facebook.presto.metadata.InternalNodeManager;
import com.facebook.presto.metadata.OperatorNotFoundException;
import com.facebook.presto.metadata.Signature;
import com.facebook.presto.metadata.TableHandle;
import com.facebook.presto.operator.StageExecutionStrategy;
import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.predicate.Domain;
import com.facebook.presto.spi.predicate.Marker;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.Range;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.statistics.ColumnStatisticMetadata;
import com.facebook.presto.spi.statistics.TableStatisticType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.sql.InterpretedFunctionInvoker;
import com.facebook.presto.sql.planner.OrderingScheme;
import com.facebook.presto.sql.planner.Partitioning;
import com.facebook.presto.sql.planner.PartitioningScheme;
import com.facebook.presto.sql.planner.PlanFragment;
import com.facebook.presto.sql.planner.SubPlan;
import com.facebook.presto.sql.planner.Symbol;
import com.facebook.presto.sql.planner.SystemPartitioningHandle;
import com.facebook.presto.sql.planner.TypeProvider;
import com.facebook.presto.sql.planner.iterative.GroupReference;
import com.facebook.presto.sql.planner.plan.AggregationNode;
import com.facebook.presto.sql.planner.plan.ApplyNode;
import com.facebook.presto.sql.planner.plan.AssignUniqueId;
import com.facebook.presto.sql.planner.plan.Assignments;
import com.facebook.presto.sql.planner.plan.DeleteNode;
import com.facebook.presto.sql.planner.plan.DistinctLimitNode;
import com.facebook.presto.sql.planner.plan.EnforceSingleRowNode;
import com.facebook.presto.sql.planner.plan.ExceptNode;
import com.facebook.presto.sql.planner.plan.ExchangeNode;
import com.facebook.presto.sql.planner.plan.ExplainAnalyzeNode;
import com.facebook.presto.sql.planner.plan.FilterNode;
import com.facebook.presto.sql.planner.plan.GroupIdNode;
import com.facebook.presto.sql.planner.plan.IndexJoinNode;
import com.facebook.presto.sql.planner.plan.IndexSourceNode;
import com.facebook.presto.sql.planner.plan.IntersectNode;
import com.facebook.presto.sql.planner.plan.JoinNode;
import com.facebook.presto.sql.planner.plan.LateralJoinNode;
import com.facebook.presto.sql.planner.plan.LimitNode;
import com.facebook.presto.sql.planner.plan.MarkDistinctNode;
import com.facebook.presto.sql.planner.plan.MetadataDeleteNode;
import com.facebook.presto.sql.planner.plan.OutputNode;
import com.facebook.presto.sql.planner.plan.PlanFragmentId;
import com.facebook.presto.sql.planner.plan.PlanNode;
import com.facebook.presto.sql.planner.plan.PlanNodeId;
import com.facebook.presto.sql.planner.plan.PlanVisitor;
import com.facebook.presto.sql.planner.plan.ProjectNode;
import com.facebook.presto.sql.planner.plan.RemoteSourceNode;
import com.facebook.presto.sql.planner.plan.RowNumberNode;
import com.facebook.presto.sql.planner.plan.SampleNode;
import com.facebook.presto.sql.planner.plan.SemiJoinNode;
import com.facebook.presto.sql.planner.plan.SortNode;
import com.facebook.presto.sql.planner.plan.StatisticAggregations;
import com.facebook.presto.sql.planner.plan.StatisticAggregationsDescriptor;
import com.facebook.presto.sql.planner.plan.TableFinishNode;
import com.facebook.presto.sql.planner.plan.TableScanNode;
import com.facebook.presto.sql.planner.plan.TableWriterNode;
import com.facebook.presto.sql.planner.plan.TopNNode;
import com.facebook.presto.sql.planner.plan.TopNRowNumberNode;
import com.facebook.presto.sql.planner.plan.UnionNode;
import com.facebook.presto.sql.planner.plan.UnnestNode;
import com.facebook.presto.sql.planner.plan.ValuesNode;
import com.facebook.presto.sql.planner.plan.WindowNode;
import com.facebook.presto.sql.planner.planPrinter.PlanNodeStats;
import com.facebook.presto.sql.planner.planPrinter.PlanNodeStatsSummarizer;
import com.facebook.presto.sql.planner.planPrinter.WindowOperatorStats;
import com.facebook.presto.sql.tree.ComparisonExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.SymbolReference;
import com.facebook.presto.util.GraphvizPrinter;
import com.google.common.base.CaseFormat;
import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.base.Verify;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import io.airlift.slice.Slice;
import io.airlift.units.DataSize;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class PlanPrinter {
    private final StringBuilder output = new StringBuilder();
    private final FunctionRegistry functionRegistry;
    private final Optional<Map<PlanNodeId, PlanNodeStats>> stats;
    private final boolean verbose;

    private PlanPrinter(PlanNode plan, TypeProvider types, Optional<StageExecutionStrategy> stageExecutionStrategy, FunctionRegistry functionRegistry, StatsProvider statsProvider, CostProvider costProvider, Session session, Optional<Map<PlanNodeId, PlanNodeStats>> stats, int indent, boolean verbose) {
        Objects.requireNonNull(plan, "plan is null");
        Objects.requireNonNull(types, "types is null");
        Objects.requireNonNull(functionRegistry, "functionRegistry is null");
        Objects.requireNonNull(statsProvider, "statsProvider is null");
        Objects.requireNonNull(costProvider, "costProvider is null");
        this.functionRegistry = functionRegistry;
        this.stats = stats;
        this.verbose = verbose;
        Visitor visitor = new Visitor(stageExecutionStrategy, statsProvider, costProvider, types, session);
        plan.accept(visitor, indent);
    }

    public String toString() {
        return this.output.toString();
    }

    public static String textLogicalPlan(PlanNode plan, TypeProvider types, FunctionRegistry functionRegistry, StatsProvider statsProvider, CostProvider costProvider, Session session, int indent) {
        return new PlanPrinter(plan, types, Optional.empty(), functionRegistry, statsProvider, costProvider, session, Optional.empty(), indent, false).toString();
    }

    public static String textLogicalPlan(PlanNode plan, TypeProvider types, FunctionRegistry functionRegistry, StatsCalculator statsCalculator, CostCalculator costCalculator, Session session, int indent, boolean verbose) {
        return PlanPrinter.textLogicalPlan(plan, types, Optional.empty(), functionRegistry, statsCalculator, costCalculator, PlanNode::getSources, session, Optional.empty(), indent, verbose);
    }

    public static String textLogicalPlan(PlanNode plan, TypeProvider types, Optional<StageExecutionStrategy> stageExecutionStrategy, FunctionRegistry functionRegistry, StatsCalculator statsCalculator, CostCalculator costCalculator, PlanNodeSourceProvider sourceProvider, Session session, Optional<Map<PlanNodeId, PlanNodeStats>> stats, int indent, boolean verbose) {
        CachingStatsProvider statsProvider = new CachingStatsProvider(statsCalculator, session, types);
        CachingCostProvider costProvider = new CachingCostProvider(costCalculator, statsProvider, session, types, sourceProvider);
        return new PlanPrinter(plan, types, stageExecutionStrategy, functionRegistry, statsProvider, costProvider, session, stats, indent, verbose).toString();
    }

    public static String textDistributedPlan(StageInfo outputStageInfo, FunctionRegistry functionRegistry, StatsCalculator statsCalculator, CostCalculator costCalculator, InternalNodeManager nodeManager, NodeSchedulerConfig nodeSchedulerConfig, Session session, boolean verbose) {
        StringBuilder builder = new StringBuilder();
        List<StageInfo> allStages = StageInfo.getAllStages(Optional.of(outputStageInfo));
        List allFragments = (List)allStages.stream().map(StageInfo::getPlan).collect(ImmutableList.toImmutableList());
        for (StageInfo stageInfo : allStages) {
            Map<PlanNodeId, PlanNodeStats> aggregatedStats = PlanNodeStatsSummarizer.aggregatePlanNodeStats(stageInfo);
            builder.append(PlanPrinter.formatFragment(functionRegistry, statsCalculator, costCalculator, nodeManager, nodeSchedulerConfig, session, stageInfo.getPlan(), Optional.of(stageInfo), Optional.of(aggregatedStats), verbose, allFragments));
        }
        return builder.toString();
    }

    public static String textDistributedPlan(SubPlan plan, FunctionRegistry functionRegistry, StatsCalculator statsCalculator, CostCalculator costCalculator, InternalNodeManager nodeManager, NodeSchedulerConfig nodeSchedulerConfig, Session session, boolean verbose) {
        StringBuilder builder = new StringBuilder();
        for (PlanFragment fragment : plan.getAllFragments()) {
            builder.append(PlanPrinter.formatFragment(functionRegistry, statsCalculator, costCalculator, nodeManager, nodeSchedulerConfig, session, fragment, Optional.empty(), Optional.empty(), verbose, plan.getAllFragments()));
        }
        return builder.toString();
    }

    private static String formatFragment(FunctionRegistry functionRegistry, StatsCalculator statsCalculator, CostCalculator costCalculator, InternalNodeManager nodeManager, NodeSchedulerConfig nodeSchedulerConfig, Session session, PlanFragment fragment, Optional<StageInfo> stageInfo, Optional<Map<PlanNodeId, PlanNodeStats>> planNodeStats, boolean verbose, List<PlanFragment> allFragments) {
        StringBuilder builder = new StringBuilder();
        builder.append(String.format("Fragment %s [%s]\n", fragment.getId(), fragment.getPartitioning()));
        if (stageInfo.isPresent()) {
            StageStats stageStats = stageInfo.get().getStageStats();
            double avgPositionsPerTask = stageInfo.get().getTasks().stream().mapToLong(task -> task.getStats().getProcessedInputPositions()).average().orElse(Double.NaN);
            double squaredDifferences = stageInfo.get().getTasks().stream().mapToDouble(task -> Math.pow((double)task.getStats().getProcessedInputPositions() - avgPositionsPerTask, 2.0)).sum();
            double sdAmongTasks = Math.sqrt(squaredDifferences / (double)stageInfo.get().getTasks().size());
            builder.append(PlanPrinter.indentString(1)).append(String.format("CPU: %s, Input: %s (%s); per task: avg.: %s std.dev.: %s, Output: %s (%s)\n", stageStats.getTotalCpuTime(), PlanPrinter.formatPositions(stageStats.getProcessedInputPositions()), stageStats.getProcessedInputDataSize(), PlanPrinter.formatDouble(avgPositionsPerTask), PlanPrinter.formatDouble(sdAmongTasks), PlanPrinter.formatPositions(stageStats.getOutputPositions()), stageStats.getOutputDataSize()));
        }
        PartitioningScheme partitioningScheme = fragment.getPartitioningScheme();
        builder.append(PlanPrinter.indentString(1)).append(String.format("Output layout: [%s]\n", Joiner.on((String)", ").join(partitioningScheme.getOutputLayout())));
        boolean replicateNullsAndAny = partitioningScheme.isReplicateNullsAndAny();
        List arguments = (List)partitioningScheme.getPartitioning().getArguments().stream().map(argument -> {
            if (argument.isConstant()) {
                NullableValue constant = argument.getConstant();
                String printableValue = PlanPrinter.castToVarchar(constant.getType(), constant.getValue(), functionRegistry, session);
                return constant.getType().getDisplayName() + "(" + printableValue + ")";
            }
            return argument.getColumn().toString();
        }).collect(ImmutableList.toImmutableList());
        builder.append(PlanPrinter.indentString(1));
        if (replicateNullsAndAny) {
            builder.append(String.format("Output partitioning: %s (replicate nulls and any) [%s]%s\n", partitioningScheme.getPartitioning().getHandle(), Joiner.on((String)", ").join((Iterable)arguments), PlanPrinter.formatHash(partitioningScheme.getHashColumn())));
        } else {
            builder.append(String.format("Output partitioning: %s [%s]%s\n", partitioningScheme.getPartitioning().getHandle(), Joiner.on((String)", ").join((Iterable)arguments), PlanPrinter.formatHash(partitioningScheme.getHashColumn())));
        }
        builder.append(PlanPrinter.indentString(1)).append(String.format("Grouped Execution: %s\n", fragment.getStageExecutionStrategy().isAnyScanGroupedExecution()));
        TypeProvider typeProvider = TypeProvider.copyOf((Map)allFragments.stream().flatMap(f -> f.getSymbols().entrySet().stream()).distinct().collect(ImmutableMap.toImmutableMap(Map.Entry::getKey, Map.Entry::getValue)));
        FragmentedPlanSourceProvider sourceProvider = FragmentedPlanSourceProvider.create(allFragments);
        statsCalculator = new FragmentedPlanStatsCalculator(statsCalculator, sourceProvider);
        costCalculator = new FragmentedPlanCostCalculator(sourceProvider, costCalculator, nodeManager, nodeSchedulerConfig);
        builder.append(PlanPrinter.textLogicalPlan(fragment.getRoot(), typeProvider, Optional.of(fragment.getStageExecutionStrategy()), functionRegistry, statsCalculator, costCalculator, sourceProvider, session, planNodeStats, 1, verbose)).append("\n");
        return builder.toString();
    }

    public static String graphvizLogicalPlan(PlanNode plan, TypeProvider types) {
        PlanFragment fragment = new PlanFragment(new PlanFragmentId("graphviz_plan"), plan, types.allTypes(), SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<PlanNodeId>)ImmutableList.of((Object)plan.getId()), new PartitioningScheme(Partitioning.create(SystemPartitioningHandle.SINGLE_DISTRIBUTION, (List<Symbol>)ImmutableList.of()), plan.getOutputSymbols()), StageExecutionStrategy.ungroupedExecution());
        return GraphvizPrinter.printLogical((List<PlanFragment>)ImmutableList.of((Object)fragment));
    }

    public static String graphvizDistributedPlan(SubPlan plan) {
        return GraphvizPrinter.printDistributed(plan);
    }

    private void print(int indent, String format, Object ... args) {
        String value = args.length == 0 ? format : String.format(format, args);
        this.output.append(PlanPrinter.indentString(indent)).append(value).append('\n');
    }

    private void print(int indent, String format, List<Object> args) {
        this.print(indent, format, args.toArray(new Object[args.size()]));
    }

    private void printStats(int intent, PlanNodeId planNodeId) {
        this.printStats(intent, planNodeId, false, false);
    }

    private void printStats(int indent, PlanNodeId planNodeId, boolean printInput, boolean printFiltered) {
        if (!this.stats.isPresent()) {
            return;
        }
        long totalMillis = this.stats.get().values().stream().mapToLong(node -> node.getPlanNodeWallTime().toMillis()).sum();
        PlanNodeStats nodeStats = this.stats.get().get(planNodeId);
        if (nodeStats == null) {
            this.output.append(PlanPrinter.indentString(indent));
            this.output.append("Cost: ?");
            if (printInput) {
                this.output.append(", Input: ? rows (?B)");
            }
            this.output.append(", Output: ? rows (?B)");
            if (printFiltered) {
                this.output.append(", Filtered: ?%");
            }
            this.output.append('\n');
            return;
        }
        double fraction = 100.0 * (double)nodeStats.getPlanNodeWallTime().toMillis() / (double)totalMillis;
        this.output.append(PlanPrinter.indentString(indent));
        this.output.append("CPU fraction: " + PlanPrinter.formatDouble(fraction) + "%");
        if (printInput) {
            this.output.append(String.format(", Input: %s (%s)", PlanPrinter.formatPositions(nodeStats.getPlanNodeInputPositions()), nodeStats.getPlanNodeInputDataSize().toString()));
        }
        this.output.append(String.format(", Output: %s (%s)", PlanPrinter.formatPositions(nodeStats.getPlanNodeOutputPositions()), nodeStats.getPlanNodeOutputDataSize().toString()));
        if (printFiltered) {
            double filtered = 100.0 * (double)(nodeStats.getPlanNodeInputPositions() - nodeStats.getPlanNodeOutputPositions()) / (double)nodeStats.getPlanNodeInputPositions();
            this.output.append(", Filtered: " + PlanPrinter.formatDouble(filtered) + "%");
        }
        this.output.append('\n');
        this.printDistributions(indent, nodeStats);
        if (nodeStats.getWindowOperatorStats().isPresent()) {
            this.printWindowOperatorStats(indent, nodeStats.getWindowOperatorStats().get());
        }
    }

    private void printDistributions(int indent, PlanNodeStats nodeStats) {
        Map<String, Double> inputAverages = nodeStats.getOperatorInputPositionsAverages();
        Map<String, Double> inputStdDevs = nodeStats.getOperatorInputPositionsStdDevs();
        Map<String, Double> hashCollisionsAverages = nodeStats.getOperatorHashCollisionsAverages();
        Map<String, Double> hashCollisionsStdDevs = nodeStats.getOperatorHashCollisionsStdDevs();
        Map<String, Double> expectedHashCollisionsAverages = nodeStats.getOperatorExpectedCollisionsAverages();
        Map<String, String> translatedOperatorTypes = PlanPrinter.translateOperatorTypes(nodeStats.getOperatorTypes());
        for (String operator : translatedOperatorTypes.keySet()) {
            String translatedOperatorType = translatedOperatorTypes.get(operator);
            double inputAverage = inputAverages.get(operator);
            this.output.append(PlanPrinter.indentString(indent));
            this.output.append(translatedOperatorType);
            this.output.append(String.format(Locale.US, "Input avg.: %s rows, Input std.dev.: %s%%", PlanPrinter.formatDouble(inputAverage), PlanPrinter.formatDouble(100.0 * inputStdDevs.get(operator) / inputAverage)));
            this.output.append('\n');
            double hashCollisionsAverage = hashCollisionsAverages.getOrDefault(operator, 0.0);
            double expectedHashCollisionsAverage = expectedHashCollisionsAverages.getOrDefault(operator, 0.0);
            if (hashCollisionsAverage == 0.0) continue;
            double hashCollisionsStdDevRatio = hashCollisionsStdDevs.get(operator) / hashCollisionsAverage;
            if (translatedOperatorType.isEmpty()) {
                this.output.append(PlanPrinter.indentString(indent));
            } else {
                this.output.append(PlanPrinter.indentString(indent + 2));
            }
            if (expectedHashCollisionsAverage != 0.0) {
                double hashCollisionsRatio = hashCollisionsAverage / expectedHashCollisionsAverage;
                this.output.append(String.format(Locale.US, "Collisions avg.: %s (%s%% est.), Collisions std.dev.: %s%%", PlanPrinter.formatDouble(hashCollisionsAverage), PlanPrinter.formatDouble(hashCollisionsRatio * 100.0), PlanPrinter.formatDouble(hashCollisionsStdDevRatio * 100.0)));
            } else {
                this.output.append(String.format(Locale.US, "Collisions avg.: %s, Collisions std.dev.: %s%%", PlanPrinter.formatDouble(hashCollisionsAverage), PlanPrinter.formatDouble(hashCollisionsStdDevRatio * 100.0)));
            }
            this.output.append('\n');
        }
    }

    private static Map<String, String> translateOperatorTypes(Set<String> operators) {
        if (operators.size() == 1) {
            return ImmutableMap.of((Object)Iterables.getOnlyElement(operators), (Object)"");
        }
        if (operators.contains("LookupJoinOperator") && operators.contains("HashBuilderOperator")) {
            return ImmutableMap.of((Object)"LookupJoinOperator", (Object)"Left (probe) ", (Object)"HashBuilderOperator", (Object)"Right (build) ");
        }
        return ImmutableMap.of();
    }

    private void printWindowOperatorStats(int indent, WindowOperatorStats stats) {
        if (!this.verbose) {
            return;
        }
        this.output.append(PlanPrinter.indentString(indent));
        this.output.append(String.format("Active Drivers: [ %d / %d ]", stats.getActiveDrivers(), stats.getTotalDrivers()));
        this.output.append('\n');
        this.output.append(PlanPrinter.indentString(indent));
        this.output.append(String.format("Index size: std.dev.: %s bytes , %s rows", PlanPrinter.formatDouble(stats.getIndexSizeStdDev()), PlanPrinter.formatDouble(stats.getIndexPositionsStdDev())));
        this.output.append('\n');
        this.output.append(PlanPrinter.indentString(indent));
        this.output.append(String.format("Index count per driver: std.dev.: %s", PlanPrinter.formatDouble(stats.getIndexCountPerDriverStdDev())));
        this.output.append('\n');
        this.output.append(PlanPrinter.indentString(indent));
        this.output.append(String.format("Rows per driver: std.dev.: %s", PlanPrinter.formatDouble(stats.getRowsPerDriverStdDev())));
        this.output.append('\n');
        this.output.append(PlanPrinter.indentString(indent));
        this.output.append(String.format("Size of partition: std.dev.: %s", PlanPrinter.formatDouble(stats.getPartitionRowsStdDev())));
        this.output.append('\n');
    }

    private static String formatDouble(double value) {
        if (Double.isFinite(value)) {
            return String.format(Locale.US, "%.2f", value);
        }
        return "?";
    }

    private static String formatAsLong(double value) {
        if (Double.isFinite(value)) {
            return String.format(Locale.US, "%d", Math.round(value));
        }
        return "?";
    }

    private static String formatPositions(long positions) {
        if (positions == 1L) {
            return "1 row";
        }
        return positions + " rows";
    }

    private static String indentString(int indent) {
        return Strings.repeat((String)"    ", (int)indent);
    }

    private static String formatEstimateAsDataSize(double value) {
        return Double.isNaN(value) ? "?" : DataSize.succinctBytes((long)((long)value)).toString();
    }

    private static String formatHash(Optional<Symbol> ... hashes) {
        List symbols = Arrays.stream(hashes).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList());
        if (symbols.isEmpty()) {
            return "";
        }
        return "[" + Joiner.on((String)", ").join(symbols) + "]";
    }

    private static String formatFrame(WindowNode.Frame frame) {
        StringBuilder builder = new StringBuilder(frame.getType().toString());
        frame.getOriginalStartValue().ifPresent(value -> builder.append(" ").append(value));
        builder.append(" ").append(frame.getStartType());
        frame.getOriginalEndValue().ifPresent(value -> builder.append(" ").append(value));
        builder.append(" ").append(frame.getEndType());
        return builder.toString();
    }

    private static String castToVarchar(Type type, Object value, FunctionRegistry functionRegistry, Session session) {
        if (value == null) {
            return "NULL";
        }
        try {
            Signature coercion = functionRegistry.getCoercion(type, (Type)VarcharType.VARCHAR);
            Slice coerced = (Slice)new InterpretedFunctionInvoker(functionRegistry).invoke(coercion, session.toConnectorSession(), value);
            return coerced.toStringUtf8();
        }
        catch (OperatorNotFoundException e) {
            return "<UNREPRESENTABLE VALUE>";
        }
    }

    private class Visitor
    extends PlanVisitor<Void, Integer> {
        private final Optional<StageExecutionStrategy> stageExecutionStrategy;
        private final TypeProvider types;
        private final StatsProvider statsProvider;
        private final CostProvider costProvider;
        private final Session session;

        public Visitor(Optional<StageExecutionStrategy> stageExecutionStrategy, StatsProvider statsProvider, CostProvider costProvider, TypeProvider types, Session session) {
            this.stageExecutionStrategy = stageExecutionStrategy;
            this.types = types;
            this.statsProvider = statsProvider;
            this.costProvider = costProvider;
            this.session = session;
        }

        @Override
        public Void visitExplainAnalyze(ExplainAnalyzeNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- ExplainAnalyze => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitJoin(JoinNode node, Integer indent) {
            ArrayList<ComparisonExpression> joinExpressions = new ArrayList<ComparisonExpression>();
            for (JoinNode.EquiJoinClause clause : node.getCriteria()) {
                joinExpressions.add(clause.toExpression());
            }
            node.getFilter().ifPresent(joinExpressions::add);
            if (node.isSpatialJoin()) {
                PlanPrinter.this.print(indent, "- Spatial%s[%s] => [%s]", new Object[]{node.getType().getJoinLabel(), Joiner.on((String)" AND ").join(joinExpressions), this.formatOutputs(node.getOutputSymbols())});
            } else if (node.isCrossJoin()) {
                Preconditions.checkState((boolean)joinExpressions.isEmpty());
                PlanPrinter.this.print(indent, "- CrossJoin => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            } else {
                PlanPrinter.this.print(indent, "- %s[%s]%s => [%s]", new Object[]{node.getType().getJoinLabel(), Joiner.on((String)" AND ").join(joinExpressions), PlanPrinter.formatHash(new Optional[]{node.getLeftHashSymbol(), node.getRightHashSymbol()}), this.formatOutputs(node.getOutputSymbols())});
            }
            node.getDistributionType().ifPresent(distributionType -> PlanPrinter.this.print(indent + 2, "Distribution: %s", new Object[]{distributionType}));
            node.getSortExpressionContext().ifPresent(context -> PlanPrinter.this.print(indent + 2, "SortExpression[%s]", new Object[]{context.getSortExpression()}));
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            node.getLeft().accept(this, indent + 1);
            node.getRight().accept(this, indent + 1);
            return null;
        }

        @Override
        public Void visitSemiJoin(SemiJoinNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- SemiJoin[%s = %s]%s => [%s]", new Object[]{node.getSourceJoinSymbol(), node.getFilteringSourceJoinSymbol(), PlanPrinter.formatHash(new Optional[]{node.getSourceHashSymbol(), node.getFilteringSourceHashSymbol()}), this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            node.getSource().accept(this, indent + 1);
            node.getFilteringSource().accept(this, indent + 1);
            return null;
        }

        @Override
        public Void visitIndexSource(IndexSourceNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- IndexSource[%s, lookup = %s] => [%s]", new Object[]{node.getIndexHandle(), node.getLookupSymbols(), this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            for (Map.Entry<Symbol, ColumnHandle> entry : node.getAssignments().entrySet()) {
                if (!node.getOutputSymbols().contains(entry.getKey())) continue;
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{entry.getKey(), entry.getValue()});
            }
            return null;
        }

        @Override
        public Void visitIndexJoin(IndexJoinNode node, Integer indent) {
            ArrayList<ComparisonExpression> joinExpressions = new ArrayList<ComparisonExpression>();
            for (IndexJoinNode.EquiJoinClause clause : node.getCriteria()) {
                joinExpressions.add(new ComparisonExpression(ComparisonExpression.Operator.EQUAL, (Expression)clause.getProbe().toSymbolReference(), (Expression)clause.getIndex().toSymbolReference()));
            }
            PlanPrinter.this.print(indent, "- %sIndexJoin[%s]%s => [%s]", new Object[]{node.getType().getJoinLabel(), Joiner.on((String)" AND ").join(joinExpressions), PlanPrinter.formatHash(new Optional[]{node.getProbeHashSymbol(), node.getIndexHashSymbol()}), this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            node.getProbeSource().accept(this, indent + 1);
            node.getIndexSource().accept(this, indent + 1);
            return null;
        }

        @Override
        public Void visitLimit(LimitNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Limit%s[%s] => [%s]", new Object[]{node.isPartial() ? "Partial" : "", node.getCount(), this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitDistinctLimit(DistinctLimitNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- DistinctLimit%s[%s]%s => [%s]", new Object[]{node.isPartial() ? "Partial" : "", node.getLimit(), PlanPrinter.formatHash(new Optional[]{node.getHashSymbol()}), this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitAggregation(AggregationNode node, Integer indent) {
            String type = "";
            if (node.getStep() != AggregationNode.Step.SINGLE) {
                type = String.format("(%s)", node.getStep().toString());
            }
            if (node.isStreamable()) {
                type = String.format("%s(STREAMING)", type);
            }
            String key = "";
            if (!node.getGroupingKeys().isEmpty()) {
                key = node.getGroupingKeys().toString();
            }
            PlanPrinter.this.print(indent, "- Aggregate%s%s%s => [%s]", new Object[]{type, key, PlanPrinter.formatHash(new Optional[]{node.getHashSymbol()}), this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            for (Map.Entry<Symbol, AggregationNode.Aggregation> entry : node.getAggregations().entrySet()) {
                if (entry.getValue().getMask().isPresent()) {
                    PlanPrinter.this.print(indent + 2, "%s := %s (mask = %s)", new Object[]{entry.getKey(), entry.getValue().getCall(), entry.getValue().getMask().get()});
                    continue;
                }
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{entry.getKey(), entry.getValue().getCall()});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitGroupId(GroupIdNode node, Integer indent) {
            List inputGroupingSetSymbols = node.getGroupingSets().stream().map(set -> set.stream().map(symbol -> node.getGroupingColumns().get(symbol)).collect(Collectors.toList())).collect(Collectors.toList());
            PlanPrinter.this.print(indent, "- GroupId%s => [%s]", new Object[]{inputGroupingSetSymbols, this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            for (Map.Entry<Symbol, Symbol> mapping : node.getGroupingColumns().entrySet()) {
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{mapping.getKey(), mapping.getValue()});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitMarkDistinct(MarkDistinctNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- MarkDistinct[distinct=%s marker=%s]%s => [%s]", new Object[]{this.formatOutputs(node.getDistinctSymbols()), node.getMarkerSymbol(), PlanPrinter.formatHash(new Optional[]{node.getHashSymbol()}), this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitWindow(WindowNode node, Integer indent) {
            List partitionBy = Lists.transform(node.getPartitionBy(), (Function)Functions.toStringFunction());
            ArrayList<String> args = new ArrayList<String>();
            if (!partitionBy.isEmpty()) {
                List prePartitioned = (List)node.getPartitionBy().stream().filter(node.getPrePartitionedInputs()::contains).collect(ImmutableList.toImmutableList());
                List notPrePartitioned = (List)node.getPartitionBy().stream().filter(column -> !node.getPrePartitionedInputs().contains(column)).collect(ImmutableList.toImmutableList());
                StringBuilder builder = new StringBuilder();
                if (!prePartitioned.isEmpty()) {
                    builder.append("<").append(Joiner.on((String)", ").join((Iterable)prePartitioned)).append(">");
                    if (!notPrePartitioned.isEmpty()) {
                        builder.append(", ");
                    }
                }
                if (!notPrePartitioned.isEmpty()) {
                    builder.append(Joiner.on((String)", ").join((Iterable)notPrePartitioned));
                }
                args.add(String.format("partition by (%s)", builder));
            }
            if (node.getOrderingScheme().isPresent()) {
                OrderingScheme orderingScheme = node.getOrderingScheme().get();
                args.add(String.format("order by (%s)", Stream.concat(orderingScheme.getOrderBy().stream().limit(node.getPreSortedOrderPrefix()).map(symbol -> "<" + symbol + " " + orderingScheme.getOrdering((Symbol)symbol) + ">"), orderingScheme.getOrderBy().stream().skip(node.getPreSortedOrderPrefix()).map(symbol -> symbol + " " + orderingScheme.getOrdering((Symbol)symbol))).collect(Collectors.joining(", "))));
            }
            PlanPrinter.this.print(indent, "- Window[%s]%s => [%s]", new Object[]{Joiner.on((String)", ").join(args), PlanPrinter.formatHash(new Optional[]{node.getHashSymbol()}), this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            for (Map.Entry<Symbol, WindowNode.Function> entry : node.getWindowFunctions().entrySet()) {
                FunctionCall call = entry.getValue().getFunctionCall();
                String frameInfo = PlanPrinter.formatFrame(entry.getValue().getFrame());
                PlanPrinter.this.print(indent + 2, "%s := %s(%s) %s", new Object[]{entry.getKey(), call.getName(), Joiner.on((String)", ").join((Iterable)call.getArguments()), frameInfo});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitTopNRowNumber(TopNRowNumberNode node, Integer indent) {
            List partitionBy = (List)node.getPartitionBy().stream().map(Functions.toStringFunction()).collect(ImmutableList.toImmutableList());
            List orderBy = (List)node.getOrderingScheme().getOrderBy().stream().map(input -> input + " " + node.getOrderingScheme().getOrdering((Symbol)input)).collect(ImmutableList.toImmutableList());
            ArrayList<String> args = new ArrayList<String>();
            args.add(String.format("partition by (%s)", Joiner.on((String)", ").join((Iterable)partitionBy)));
            args.add(String.format("order by (%s)", Joiner.on((String)", ").join((Iterable)orderBy)));
            PlanPrinter.this.print(indent, "- TopNRowNumber[%s limit %s]%s => [%s]", new Object[]{Joiner.on((String)", ").join(args), node.getMaxRowCountPerPartition(), PlanPrinter.formatHash(new Optional[]{node.getHashSymbol()}), this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{node.getRowNumberSymbol(), "row_number()"});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitRowNumber(RowNumberNode node, Integer indent) {
            List partitionBy = Lists.transform(node.getPartitionBy(), (Function)Functions.toStringFunction());
            ArrayList<String> args = new ArrayList<String>();
            if (!partitionBy.isEmpty()) {
                args.add(String.format("partition by (%s)", Joiner.on((String)", ").join((Iterable)partitionBy)));
            }
            if (node.getMaxRowCountPerPartition().isPresent()) {
                args.add(String.format("limit = %s", node.getMaxRowCountPerPartition().get()));
            }
            PlanPrinter.this.print(indent, "- RowNumber[%s]%s => [%s]", new Object[]{Joiner.on((String)", ").join(args), PlanPrinter.formatHash(new Optional[]{node.getHashSymbol()}), this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{node.getRowNumberSymbol(), "row_number()"});
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitTableScan(TableScanNode node, Integer indent) {
            TableHandle table = node.getTable();
            if (this.stageExecutionStrategy.isPresent()) {
                PlanPrinter.this.print(indent, "- TableScan[%s, grouped = %s] => [%s]", new Object[]{table, this.stageExecutionStrategy.get().isGroupedExecution(node.getId()), this.formatOutputs(node.getOutputSymbols())});
            } else {
                PlanPrinter.this.print(indent, "- TableScan[%s] => [%s]", new Object[]{table, this.formatOutputs(node.getOutputSymbols())});
            }
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            this.printTableScanInfo(node, indent);
            return null;
        }

        @Override
        public Void visitValues(ValuesNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Values => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            for (List<Expression> row : node.getRows()) {
                PlanPrinter.this.print(indent + 2, "(" + Joiner.on((String)", ").join(row) + ")", new Object[0]);
            }
            return null;
        }

        @Override
        public Void visitFilter(FilterNode node, Integer indent) {
            return this.visitScanFilterAndProjectInfo(node.getId(), Optional.of(node), Optional.empty(), indent);
        }

        @Override
        public Void visitProject(ProjectNode node, Integer indent) {
            if (node.getSource() instanceof FilterNode) {
                return this.visitScanFilterAndProjectInfo(node.getId(), Optional.of((FilterNode)node.getSource()), Optional.of(node), indent);
            }
            return this.visitScanFilterAndProjectInfo(node.getId(), Optional.empty(), Optional.of(node), indent);
        }

        private Void visitScanFilterAndProjectInfo(PlanNodeId planNodeId, Optional<FilterNode> filterNode, Optional<ProjectNode> projectNode, int indent) {
            Preconditions.checkState((projectNode.isPresent() || filterNode.isPresent() ? 1 : 0) != 0);
            PlanNode sourceNode = filterNode.isPresent() ? filterNode.get().getSource() : projectNode.get().getSource();
            Optional<Object> scanNode = sourceNode instanceof TableScanNode ? Optional.of((TableScanNode)sourceNode) : Optional.empty();
            String format = "[";
            String operatorName = "- ";
            LinkedList<Object> arguments = new LinkedList<Object>();
            if (scanNode.isPresent()) {
                operatorName = operatorName + "Scan";
                format = format + "table = %s, ";
                TableHandle table = ((TableScanNode)scanNode.get()).getTable();
                arguments.add(table);
                if (this.stageExecutionStrategy.isPresent()) {
                    format = format + "grouped = %s, ";
                    arguments.add(this.stageExecutionStrategy.get().isGroupedExecution(((TableScanNode)scanNode.get()).getId()));
                }
            }
            if (filterNode.isPresent()) {
                operatorName = operatorName + "Filter";
                format = format + "filterPredicate = %s, ";
                arguments.add(filterNode.get().getPredicate());
            }
            if (format.length() > 1) {
                format = format.substring(0, format.length() - 2);
            }
            format = format + "] => [%s]";
            if (projectNode.isPresent()) {
                operatorName = operatorName + "Project";
                arguments.add(this.formatOutputs(projectNode.get().getOutputSymbols()));
            } else {
                arguments.add(this.formatOutputs(filterNode.get().getOutputSymbols()));
            }
            format = operatorName + format;
            PlanPrinter.this.print(indent, format, arguments);
            this.printPlanNodesStatsAndCost(indent + 2, (PlanNode[])Stream.of(scanNode, filterNode, projectNode).filter(Optional::isPresent).map(Optional::get).toArray(PlanNode[]::new));
            PlanPrinter.this.printStats(indent + 2, planNodeId, true, true);
            if (projectNode.isPresent()) {
                this.printAssignments(projectNode.get().getAssignments(), indent + 2);
            }
            if (scanNode.isPresent()) {
                this.printTableScanInfo((TableScanNode)scanNode.get(), indent);
                return null;
            }
            sourceNode.accept(this, indent + 1);
            return null;
        }

        private void printTableScanInfo(TableScanNode node, int indent) {
            TupleDomain<ColumnHandle> predicate;
            TableHandle table = node.getTable();
            if (node.getLayout().isPresent()) {
                ConnectorTableLayoutHandle layout = node.getLayout().get().getConnectorHandle();
                if (!table.getConnectorHandle().toString().equals(layout.toString())) {
                    PlanPrinter.this.print(indent + 2, "LAYOUT: %s", new Object[]{layout});
                }
            }
            if ((predicate = node.getCurrentConstraint()).isNone()) {
                PlanPrinter.this.print(indent + 2, ":: NONE", new Object[0]);
            } else {
                for (Map.Entry<Symbol, ColumnHandle> assignment : node.getAssignments().entrySet()) {
                    ColumnHandle column = assignment.getValue();
                    PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{assignment.getKey(), column});
                    this.printConstraint(indent + 3, column, predicate);
                }
                if (!predicate.isAll()) {
                    ImmutableSet outputs = ImmutableSet.copyOf(node.getAssignments().values());
                    ((Map)predicate.getDomains().get()).entrySet().stream().filter(arg_0 -> Visitor.lambda$printTableScanInfo$9((Set)outputs, arg_0)).forEach(entry -> {
                        ColumnHandle column = (ColumnHandle)entry.getKey();
                        PlanPrinter.this.print(indent + 2, "%s", new Object[]{column});
                        this.printConstraint(indent + 3, column, predicate);
                    });
                }
            }
        }

        @Override
        public Void visitUnnest(UnnestNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Unnest [replicate=%s, unnest=%s] => [%s]", new Object[]{this.formatOutputs(node.getReplicateSymbols()), this.formatOutputs(node.getUnnestSymbols().keySet()), this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitOutput(OutputNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Output[%s] => [%s]", new Object[]{Joiner.on((String)", ").join(node.getColumnNames()), this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            for (int i = 0; i < node.getColumnNames().size(); ++i) {
                Symbol symbol;
                String name = node.getColumnNames().get(i);
                if (name.equals((symbol = node.getOutputSymbols().get(i)).toString())) continue;
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{name, symbol});
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitTopN(TopNNode node, Integer indent) {
            Iterable keys = Iterables.transform(node.getOrderingScheme().getOrderBy(), input -> input + " " + node.getOrderingScheme().getOrdering((Symbol)input));
            PlanPrinter.this.print(indent, "- TopN[%s by (%s)] => [%s]", new Object[]{node.getCount(), Joiner.on((String)", ").join(keys), this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitSort(SortNode node, Integer indent) {
            Iterable keys = Iterables.transform(node.getOrderingScheme().getOrderBy(), input -> input + " " + node.getOrderingScheme().getOrdering((Symbol)input));
            boolean isPartial = false;
            if (SystemSessionProperties.isDistributedSortEnabled(this.session)) {
                isPartial = true;
            }
            PlanPrinter.this.print(indent, "- %sSort[%s] => [%s]", new Object[]{isPartial ? "Partial" : "", Joiner.on((String)", ").join(keys), this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitRemoteSource(RemoteSourceNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Remote%s[%s] => [%s]", new Object[]{node.getOrderingScheme().isPresent() ? "Merge" : "Source", Joiner.on((char)',').join(node.getSourceFragmentIds()), this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return null;
        }

        @Override
        public Void visitUnion(UnionNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Union => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitIntersect(IntersectNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Intersect => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitExcept(ExceptNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Except => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitTableWriter(TableWriterNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- TableWriter => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            for (int i = 0; i < node.getColumnNames().size(); ++i) {
                String name = node.getColumnNames().get(i);
                Symbol symbol = node.getColumns().get(i);
                PlanPrinter.this.print(indent + 2, "%s := %s", new Object[]{name, symbol});
            }
            if (node.getStatisticsAggregation().isPresent()) {
                Verify.verify((boolean)node.getStatisticsAggregationDescriptor().isPresent(), (String)"statisticsAggregationDescriptor is not present", (Object[])new Object[0]);
                this.printStatisticAggregations(node.getStatisticsAggregation().get(), node.getStatisticsAggregationDescriptor().get(), indent + 2);
            }
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitTableFinish(TableFinishNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- TableCommit[%s] => [%s]", new Object[]{node.getTarget(), this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            if (node.getStatisticsAggregation().isPresent()) {
                Verify.verify((boolean)node.getStatisticsAggregationDescriptor().isPresent(), (String)"statisticsAggregationDescriptor is not present", (Object[])new Object[0]);
                this.printStatisticAggregations(node.getStatisticsAggregation().get(), node.getStatisticsAggregationDescriptor().get(), indent + 2);
            }
            return this.processChildren(node, indent + 1);
        }

        private void printStatisticAggregations(StatisticAggregations aggregations, StatisticAggregationsDescriptor<Symbol> descriptor, int indent) {
            PlanPrinter.this.print(indent, "Collected statistics:", new Object[0]);
            this.printStatisticAggregationsInfo(descriptor.getTableStatistics(), descriptor.getColumnStatistics(), aggregations.getAggregations(), indent + 1);
            PlanPrinter.this.print(indent + 1, "grouped by => [%s]", new Object[]{this.getStatisticGroupingSetsInfo(descriptor.getGrouping())});
        }

        private String getStatisticGroupingSetsInfo(Map<String, Symbol> columnMappings) {
            return columnMappings.entrySet().stream().map(entry -> String.format("%s := %s", entry.getValue(), entry.getKey())).collect(Collectors.joining(", "));
        }

        private void printStatisticAggregationsInfo(Map<TableStatisticType, Symbol> tableStatistics, Map<ColumnStatisticMetadata, Symbol> columnStatistics, Map<Symbol, AggregationNode.Aggregation> aggregations, int indent) {
            PlanPrinter.this.print(indent, "aggregations =>", new Object[0]);
            for (Map.Entry<TableStatisticType, Symbol> entry : tableStatistics.entrySet()) {
                PlanPrinter.this.print(indent + 1, "%s => [%s := %s]", new Object[]{entry.getValue(), entry.getKey(), aggregations.get(entry.getValue()).getCall()});
            }
            for (Map.Entry<TableStatisticType, Symbol> entry : columnStatistics.entrySet()) {
                PlanPrinter.this.print(indent + 1, "%s[%s] => [%s := %s]", new Object[]{((ColumnStatisticMetadata)entry.getKey()).getStatisticType(), ((ColumnStatisticMetadata)entry.getKey()).getColumnName(), entry.getValue(), aggregations.get(entry.getValue()).getCall()});
            }
        }

        @Override
        public Void visitSample(SampleNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Sample[%s: %s] => [%s]", new Object[]{node.getSampleType(), node.getSampleRatio(), this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitExchange(ExchangeNode node, Integer indent) {
            if (node.getOrderingScheme().isPresent()) {
                OrderingScheme orderingScheme = node.getOrderingScheme().get();
                List orderBy = (List)orderingScheme.getOrderBy().stream().map(input -> input + " " + orderingScheme.getOrdering((Symbol)input)).collect(ImmutableList.toImmutableList());
                PlanPrinter.this.print(indent, "- %sMerge[%s] => [%s]", new Object[]{CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, node.getScope().toString()), Joiner.on((String)", ").join((Iterable)orderBy), this.formatOutputs(node.getOutputSymbols())});
            } else if (node.getScope() == ExchangeNode.Scope.LOCAL) {
                PlanPrinter.this.print(indent, "- LocalExchange[%s%s]%s (%s) => %s", new Object[]{node.getPartitioningScheme().getPartitioning().getHandle(), node.getPartitioningScheme().isReplicateNullsAndAny() ? " - REPLICATE NULLS AND ANY" : "", PlanPrinter.formatHash(new Optional[]{node.getPartitioningScheme().getHashColumn()}), Joiner.on((String)", ").join(node.getPartitioningScheme().getPartitioning().getArguments()), this.formatOutputs(node.getOutputSymbols())});
            } else {
                PlanPrinter.this.print(indent, "- %sExchange[%s%s]%s => %s", new Object[]{CaseFormat.UPPER_UNDERSCORE.to(CaseFormat.UPPER_CAMEL, node.getScope().toString()), node.getType(), node.getPartitioningScheme().isReplicateNullsAndAny() ? " - REPLICATE NULLS AND ANY" : "", PlanPrinter.formatHash(new Optional[]{node.getPartitioningScheme().getHashColumn()}), this.formatOutputs(node.getOutputSymbols())});
            }
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitDelete(DeleteNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Delete[%s] => [%s]", new Object[]{node.getTarget(), this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitMetadataDelete(MetadataDeleteNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- MetadataDelete[%s] => [%s]", new Object[]{node.getTarget(), this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitEnforceSingleRow(EnforceSingleRowNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Scalar => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitAssignUniqueId(AssignUniqueId node, Integer indent) {
            PlanPrinter.this.print(indent, "- AssignUniqueId => [%s]", new Object[]{this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitGroupReference(GroupReference node, Integer indent) {
            PlanPrinter.this.print(indent, "- GroupReference[%s] => [%s]", new Object[]{node.getGroupId(), this.formatOutputs(node.getOutputSymbols())});
            return null;
        }

        @Override
        public Void visitApply(ApplyNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Apply[%s] => [%s]", new Object[]{node.getCorrelation(), this.formatOutputs(node.getOutputSymbols())});
            this.printPlanNodesStatsAndCost(indent + 2, node);
            PlanPrinter.this.printStats(indent + 2, node.getId());
            this.printAssignments(node.getSubqueryAssignments(), indent + 4);
            return this.processChildren(node, indent + 1);
        }

        @Override
        public Void visitLateralJoin(LateralJoinNode node, Integer indent) {
            PlanPrinter.this.print(indent, "- Lateral[%s] => [%s]", new Object[]{node.getCorrelation(), this.formatOutputs(node.getOutputSymbols())});
            PlanPrinter.this.printStats(indent + 2, node.getId());
            return this.processChildren(node, indent + 1);
        }

        @Override
        protected Void visitPlan(PlanNode node, Integer indent) {
            throw new UnsupportedOperationException("not yet implemented: " + node.getClass().getName());
        }

        private Void processChildren(PlanNode node, int indent) {
            for (PlanNode child : node.getSources()) {
                child.accept(this, indent);
            }
            return null;
        }

        private void printAssignments(Assignments assignments, int indent) {
            for (Map.Entry<Symbol, Expression> entry : assignments.getMap().entrySet()) {
                if (entry.getValue() instanceof SymbolReference && ((SymbolReference)entry.getValue()).getName().equals(entry.getKey().getName())) continue;
                PlanPrinter.this.print(indent, "%s := %s", new Object[]{entry.getKey(), entry.getValue()});
            }
        }

        private String formatOutputs(Iterable<Symbol> symbols) {
            return Joiner.on((String)", ").join(Iterables.transform(symbols, input -> input + ":" + this.types.get((Symbol)input).getDisplayName()));
        }

        private void printConstraint(int indent, ColumnHandle column, TupleDomain<ColumnHandle> constraint) {
            Preconditions.checkArgument((!constraint.isNone() ? 1 : 0) != 0);
            Map domains = (Map)constraint.getDomains().get();
            if (!constraint.isAll() && domains.containsKey(column)) {
                PlanPrinter.this.print(indent, ":: %s", new Object[]{this.formatDomain(((Domain)domains.get(column)).simplify())});
            }
        }

        private String formatDomain(Domain domain) {
            ImmutableList.Builder parts = ImmutableList.builder();
            if (domain.isNullAllowed()) {
                parts.add((Object)"NULL");
            }
            Type type = domain.getType();
            domain.getValues().getValuesProcessor().consume(ranges -> {
                for (Range range : ranges.getOrderedRanges()) {
                    StringBuilder builder = new StringBuilder();
                    if (range.isSingleValue()) {
                        String value = PlanPrinter.castToVarchar(type, range.getSingleValue(), PlanPrinter.this.functionRegistry, this.session);
                        builder.append('[').append(value).append(']');
                    } else {
                        builder.append(range.getLow().getBound() == Marker.Bound.EXACTLY ? (char)'[' : (char)'(');
                        if (range.getLow().isLowerUnbounded()) {
                            builder.append("<min>");
                        } else {
                            builder.append(PlanPrinter.castToVarchar(type, range.getLow().getValue(), PlanPrinter.this.functionRegistry, this.session));
                        }
                        builder.append(", ");
                        if (range.getHigh().isUpperUnbounded()) {
                            builder.append("<max>");
                        } else {
                            builder.append(PlanPrinter.castToVarchar(type, range.getHigh().getValue(), PlanPrinter.this.functionRegistry, this.session));
                        }
                        builder.append(range.getHigh().getBound() == Marker.Bound.EXACTLY ? (char)']' : (char)')');
                    }
                    parts.add((Object)builder.toString());
                }
            }, discreteValues -> discreteValues.getValues().stream().map(value -> PlanPrinter.castToVarchar(type, value, PlanPrinter.this.functionRegistry, this.session)).sorted().forEach(arg_0 -> ((ImmutableList.Builder)parts).add(arg_0)), allOrNone -> {
                if (allOrNone.isAll()) {
                    parts.add((Object)"ALL VALUES");
                }
            });
            return "[" + Joiner.on((String)", ").join((Iterable)parts.build()) + "]";
        }

        private void printPlanNodesStatsAndCost(int indent, PlanNode ... nodes) {
            if (Arrays.stream(nodes).anyMatch(this::isKnownPlanNodeStatsOrCost)) {
                String formattedStatsAndCost = Joiner.on((String)"/").join((Iterable)Arrays.stream(nodes).map(this::formatPlanNodeStatsAndCost).collect(ImmutableList.toImmutableList()));
                PlanPrinter.this.print(indent, "Cost: %s", new Object[]{formattedStatsAndCost});
            }
        }

        private boolean isKnownPlanNodeStatsOrCost(PlanNode node) {
            return !PlanNodeStatsEstimate.UNKNOWN_STATS.equals(this.statsProvider.getStats(node)) || !PlanNodeCostEstimate.UNKNOWN_COST.equals(this.costProvider.getCumulativeCost(node));
        }

        private String formatPlanNodeStatsAndCost(PlanNode node) {
            PlanNodeStatsEstimate stats = this.statsProvider.getStats(node);
            PlanNodeCostEstimate cost = this.costProvider.getCumulativeCost(node);
            return String.format("{rows: %s (%s), cpu: %s, memory: %s, network: %s}", PlanPrinter.formatAsLong(stats.getOutputRowCount()), PlanPrinter.formatEstimateAsDataSize(stats.getOutputSizeInBytes(node.getOutputSymbols(), this.types)), PlanPrinter.formatDouble(cost.getCpuCost()), PlanPrinter.formatDouble(cost.getMemoryCost()), PlanPrinter.formatDouble(cost.getNetworkCost()));
        }

        private static /* synthetic */ boolean lambda$printTableScanInfo$9(Set outputs, Map.Entry entry) {
            return !outputs.contains(entry.getKey());
        }
    }
}

