/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.transaction;

import com.facebook.presto.connector.ConnectorId;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.facebook.presto.transaction.TransactionId;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.joda.time.DateTime;

public class TransactionInfo {
    private final TransactionId transactionId;
    private final IsolationLevel isolationLevel;
    private final boolean readOnly;
    private final boolean autoCommitContext;
    private final DateTime createTime;
    private final Duration idleTime;
    private final List<ConnectorId> connectorIds;
    private final Optional<ConnectorId> writtenConnectorId;

    public TransactionInfo(TransactionId transactionId, IsolationLevel isolationLevel, boolean readOnly, boolean autoCommitContext, DateTime createTime, Duration idleTime, List<ConnectorId> connectorIds, Optional<ConnectorId> writtenConnectorId) {
        this.transactionId = Objects.requireNonNull(transactionId, "transactionId is null");
        this.isolationLevel = Objects.requireNonNull(isolationLevel, "isolationLevel is null");
        this.readOnly = readOnly;
        this.autoCommitContext = autoCommitContext;
        this.createTime = Objects.requireNonNull(createTime, "createTime is null");
        this.idleTime = Objects.requireNonNull(idleTime, "idleTime is null");
        this.connectorIds = ImmutableList.copyOf((Collection)Objects.requireNonNull(connectorIds, "connectorIds is null"));
        this.writtenConnectorId = Objects.requireNonNull(writtenConnectorId, "writtenConnectorId is null");
    }

    public TransactionId getTransactionId() {
        return this.transactionId;
    }

    public IsolationLevel getIsolationLevel() {
        return this.isolationLevel;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public boolean isAutoCommitContext() {
        return this.autoCommitContext;
    }

    public DateTime getCreateTime() {
        return this.createTime;
    }

    public Duration getIdleTime() {
        return this.idleTime;
    }

    public List<ConnectorId> getConnectorIds() {
        return this.connectorIds;
    }

    public Optional<ConnectorId> getWrittenConnectorId() {
        return this.writtenConnectorId;
    }
}

